/*
 * Fritz!Box plugin for VDR
 *
 * Copyright (C) 2007 Joachim Wilke <vdr@joachim-wilke.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 * 
 */

#ifndef LOG_H_
#define LOG_H_

#include <string>

#define ilog cLog::infoLog  << "__FILE__:__LINE__ " 
#define elog cLog::errorLog << "__FILE__:__LINE__ " 
#define dlog cLog::debugLog << "__FILE__:__LINE__ "
#define endl '\n'

class cLog
{
private:
	std::string buffer;
	void Flush();		
public:
	static cLog *infoLog;
	static cLog *errorLog;
	static cLog *debugLog;
	enum Type {	
		CLOG_INFO,
		CLOG_ERROR,
		CLOG_DEBUG,
	} type;
	static void Init();
	cLog(Type t);
	virtual ~cLog();
	cLog &operator<<(std::string &s);
	cLog &operator<<(char *s);
	cLog &operator<<(char c);
};


#endif /*LOG_H_*/
