/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.dom.svg;

import org.apache.fop.messaging.MessageHandler;
import org.w3c.dom.svg.SVGException;
import org.w3c.dom.svg.SVGLength;

public class SVGLengthImpl
implements SVGLength {
    short unitType = 0;
    protected float millipoints = 0.0f;
    protected float fontsize = 12.0f;

    public SVGLengthImpl() {
    }

    public SVGLengthImpl(String string) {
        this.convert(string);
    }

    protected void convert(String string) {
        int n = string.length();
        if (n == 0) {
            System.err.println("WARNING: empty length");
            this.millipoints = 0.0f;
        } else {
            float f;
            this.millipoints = f = this.getFloatValue(string, n);
        }
    }

    public void convertToSpecifiedUnits(short s) throws SVGException {
    }

    public float getAnimatedValue() {
        return 0.0f;
    }

    protected float getFloatValue(String string, int n) {
        float f;
        boolean bl = true;
        try {
            if (string.endsWith("in")) {
                f = Float.valueOf(string.substring(0, n - 2)).floatValue();
                f *= 72.0f;
                this.unitType = (short)8;
            } else if (string.endsWith("cm")) {
                f = Float.valueOf(string.substring(0, n - 2)).floatValue();
                f *= 28.35f;
                this.unitType = (short)6;
            } else if (string.endsWith("mm")) {
                f = Float.valueOf(string.substring(0, n - 2)).floatValue();
                f *= 2.84f;
                this.unitType = (short)7;
            } else if (string.endsWith("pt")) {
                f = Float.valueOf(string.substring(0, n - 2)).floatValue();
                this.unitType = (short)9;
            } else if (string.endsWith("pc")) {
                f = Float.valueOf(string.substring(0, n - 2)).floatValue();
                f *= 12.0f;
                this.unitType = (short)10;
            } else if (string.endsWith("em")) {
                f = Float.valueOf(string.substring(0, n - 2)).floatValue();
                f *= this.fontsize;
                this.unitType = (short)3;
            } else if (string.endsWith("px")) {
                f = Float.valueOf(string.substring(0, n - 2)).floatValue();
                f *= (float)bl;
                this.unitType = (short)5;
            } else if (string.endsWith("%")) {
                f = Float.valueOf(string.substring(0, n - 1)).floatValue() / 100.0f;
                this.unitType = (short)2;
            } else {
                f = Float.valueOf(string).floatValue();
                this.unitType = 1;
            }
        }
        catch (Exception exception) {
            f = 0.0f;
            this.unitType = 0;
            MessageHandler.errorln("ERROR: unknown length units in " + string);
        }
        return f;
    }

    public short getUnitType() {
        return this.unitType;
    }

    public float getValue() {
        return this.millipoints;
    }

    public String getValueAsString() {
        return null;
    }

    public float getValueInSpecifiedUnits() {
        return 0.0f;
    }

    public void newValueSpecifiedUnits(short s, float f) throws SVGException {
        this.unitType = s;
        this.millipoints = f;
    }

    public void setValue(float f) {
        this.millipoints = f;
    }

    public void setValueAsString(String string) {
        this.convert(string);
    }

    public void setValueInSpecifiedUnits(float f) {
    }

    public String toString() {
        String string = String.valueOf(this.millipoints) + "mpt";
        return string;
    }
}

