/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FOText;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.FObjMixed;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.FontState;

public class Block
extends FObjMixed {
    FontState fs;
    int align;
    int alignLast;
    int breakBefore;
    int breakAfter;
    int lineHeight;
    int startIndent;
    int endIndent;
    int spaceBefore;
    int spaceAfter;
    int textIndent;
    int keepWithNext;
    ColorType backgroundColor;
    int paddingTop;
    int paddingBottom;
    int paddingLeft;
    int paddingRight;
    int blockWidows;
    int blockOrphans;
    String id;
    ColorType borderTopColor;
    int borderTopWidth;
    int borderTopStyle;
    ColorType borderBottomColor;
    int borderBottomWidth;
    int borderBottomStyle;
    ColorType borderLeftColor;
    int borderLeftWidth;
    int borderLeftStyle;
    ColorType borderRightColor;
    int borderRightWidth;
    int borderRightStyle;
    int hyphenate;
    char hyphenationChar;
    int hyphenationPushCharacterCount;
    int hyphenationRemainCharacterCount;
    String language;
    String country;
    int span;
    BlockArea blockArea;
    boolean anythingLaidOut = false;

    public Block(FObj fObj, PropertyList propertyList) {
        super(fObj, propertyList);
        this.name = "fo:block";
        this.span = this.properties.get("span").getEnum();
    }

    public int getAreaHeight() {
        return this.blockArea.getHeight();
    }

    public int getContentWidth() {
        if (this.blockArea != null) {
            return this.blockArea.getContentWidth();
        }
        return 0;
    }

    public int getSpan() {
        return this.span;
    }

    public Status layout(Area area) throws FOPException {
        if (this.marker == -1001) {
            return new Status(1);
        }
        if (this.marker == -1000) {
            String string = this.properties.get("font-family").getString();
            String string2 = this.properties.get("font-style").getString();
            String string3 = this.properties.get("font-weight").getString();
            int n = this.properties.get("font-size").getLength().mvalue();
            int n2 = this.properties.get("font-variant").getEnum();
            this.fs = new FontState(area.getFontInfo(), string, string2, string3, n, n2);
            this.align = this.properties.get("text-align").getEnum();
            this.alignLast = this.properties.get("text-align-last").getEnum();
            this.breakBefore = this.properties.get("break-before").getEnum();
            this.breakAfter = this.properties.get("break-after").getEnum();
            this.lineHeight = this.properties.get("line-height").getLength().mvalue();
            this.startIndent = this.properties.get("start-indent").getLength().mvalue();
            this.endIndent = this.properties.get("end-indent").getLength().mvalue();
            this.spaceBefore = this.properties.get("space-before.optimum").getLength().mvalue();
            this.spaceAfter = this.properties.get("space-after.optimum").getLength().mvalue();
            this.textIndent = this.properties.get("text-indent").getLength().mvalue();
            this.keepWithNext = this.properties.get("keep-with-next").getEnum();
            this.backgroundColor = this.properties.get("background-color").getColorType();
            this.paddingLeft = this.paddingTop = this.properties.get("padding").getLength().mvalue();
            this.paddingRight = this.paddingTop;
            this.paddingBottom = this.paddingTop;
            if (this.paddingTop == 0) {
                this.paddingTop = this.properties.get("padding-top").getLength().mvalue();
                this.paddingLeft = this.properties.get("padding-left").getLength().mvalue();
                this.paddingBottom = this.properties.get("padding-bottom").getLength().mvalue();
                this.paddingRight = this.properties.get("padding-right").getLength().mvalue();
            }
            this.borderBottomColor = this.borderTopColor = this.properties.get("border-color").getColorType();
            this.borderLeftColor = this.borderTopColor;
            this.borderRightColor = this.borderTopColor;
            if (this.borderTopColor == null) {
                this.borderTopColor = this.properties.get("border-top-color").getColorType();
                this.borderBottomColor = this.properties.get("border-bottom-color").getColorType();
                this.borderLeftColor = this.properties.get("border-left-color").getColorType();
                this.borderRightColor = this.properties.get("border-right-color").getColorType();
            }
            this.borderBottomWidth = this.borderTopWidth = this.properties.get("border-width").getLength().mvalue();
            this.borderLeftWidth = this.borderTopWidth;
            this.borderRightWidth = this.borderTopWidth;
            if (this.borderTopWidth == 0) {
                this.borderTopWidth = this.properties.get("border-top-width").getLength().mvalue();
                this.borderBottomWidth = this.properties.get("border-bottom-width").getLength().mvalue();
                this.borderLeftWidth = this.properties.get("border-left-width").getLength().mvalue();
                this.borderRightWidth = this.properties.get("border-right-width").getLength().mvalue();
            }
            this.borderBottomStyle = this.borderTopStyle = this.properties.get("border-style").getEnum();
            this.borderLeftStyle = this.borderTopStyle;
            this.borderRightStyle = this.borderTopStyle;
            if (this.borderTopStyle == 0) {
                this.borderTopStyle = this.properties.get("border-top-style").getEnum();
                this.borderBottomStyle = this.properties.get("border-bottom-style").getEnum();
                this.borderLeftStyle = this.properties.get("border-left-style").getEnum();
                this.borderRightStyle = this.properties.get("border-right-style").getEnum();
            }
            this.blockWidows = this.properties.get("widows").getNumber().intValue();
            this.blockOrphans = this.properties.get("orphans").getNumber().intValue();
            this.hyphenate = this.properties.get("hyphenate").getEnum();
            this.hyphenationChar = this.properties.get("hyphenation-character").getCharacter();
            this.hyphenationPushCharacterCount = this.properties.get("hyphenation-push-character-count").getNumber().intValue();
            this.hyphenationRemainCharacterCount = this.properties.get("hyphenation-remain-character-count").getNumber().intValue();
            this.language = this.properties.get("language").getString();
            this.country = this.properties.get("country").getString();
            this.id = this.properties.get("id").getString();
            if (area instanceof BlockArea) {
                area.end();
            }
            if (this.isInLabel) {
                this.startIndent += this.bodyIndent;
                this.endIndent += area.getAllocationWidth() - this.distanceBetweenStarts - this.startIndent + this.labelSeparation;
            } else if (this.isInListBody) {
                this.startIndent += this.bodyIndent + this.distanceBetweenStarts;
            }
            if (area.getIDReferences() != null) {
                area.getIDReferences().createID(this.id);
            }
            this.marker = 0;
            if (this.breakBefore == 3) {
                return new Status(4);
            }
            if (this.breakBefore == 5) {
                return new Status(6);
            }
            if (this.breakBefore == 4) {
                return new Status(5);
            }
            if (this.breakBefore == 2) {
                return new Status(7);
            }
            int n3 = this.children.size();
            int n4 = 0;
            while (n4 < n3) {
                FONode fONode = (FONode)this.children.elementAt(n4);
                if (fONode instanceof FOText) {
                    if (((FOText)fONode).willCreateArea()) {
                        fONode.setWidows(this.blockWidows);
                        break;
                    }
                    this.children.removeElementAt(n4);
                    n3 = this.children.size();
                    --n4;
                } else {
                    fONode.setWidows(this.blockWidows);
                    break;
                }
                ++n4;
            }
            int n5 = n3 - 1;
            while (n5 >= 0) {
                FONode fONode = (FONode)this.children.elementAt(n5);
                if (fONode instanceof FOText) {
                    if (((FOText)fONode).willCreateArea()) {
                        fONode.setOrphans(this.blockOrphans);
                        break;
                    }
                } else {
                    fONode.setOrphans(this.blockOrphans);
                    break;
                }
                --n5;
            }
        }
        if (this.spaceBefore != 0 && this.marker == 0) {
            area.addDisplaySpace(this.spaceBefore);
        }
        if (this.anythingLaidOut) {
            this.textIndent = 0;
        }
        if (this.marker == 0 && area.getIDReferences() != null) {
            area.getIDReferences().configureID(this.id, area);
        }
        int n = area.spaceLeft();
        this.blockArea = new BlockArea(this.fs, area.getAllocationWidth(), area.spaceLeft(), this.startIndent, this.endIndent, this.textIndent, this.align, this.alignLast, this.lineHeight);
        this.blockArea.setParent(area);
        this.blockArea.setPage(area.getPage());
        this.blockArea.setBackgroundColor(this.backgroundColor);
        this.blockArea.setPadding(this.paddingTop, this.paddingLeft, this.paddingBottom, this.paddingRight);
        this.blockArea.setBorderStyle(this.borderTopStyle, this.borderLeftStyle, this.borderBottomStyle, this.borderRightStyle);
        this.blockArea.setBorderWidth(this.borderTopWidth, this.borderLeftWidth, this.borderBottomWidth, this.borderRightWidth);
        this.blockArea.setBorderColor(this.borderTopColor, this.borderLeftColor, this.borderBottomColor, this.borderRightColor);
        this.blockArea.setHyphenation(this.language, this.country, this.hyphenate, this.hyphenationChar, this.hyphenationPushCharacterCount, this.hyphenationRemainCharacterCount);
        this.blockArea.start();
        this.blockArea.setAbsoluteHeight(area.getAbsoluteHeight());
        this.blockArea.setIDReferences(area.getIDReferences());
        this.blockArea.setTableCellXOffset(area.getTableCellXOffset());
        int n6 = this.children.size();
        int n7 = this.marker;
        while (n7 < n6) {
            Status status;
            FONode fONode = (FONode)this.children.elementAt(n7);
            if (this.isInListBody) {
                fONode.setIsInListBody();
                fONode.setDistanceBetweenStarts(this.distanceBetweenStarts);
                fONode.setBodyIndent(this.bodyIndent);
            }
            if ((status = fONode.layout(this.blockArea)).isIncomplete()) {
                this.marker = n7;
                if (status.getCode() == 2) {
                    if (n7 != 0) {
                        status = new Status(3);
                        area.addChild(this.blockArea);
                        area.setMaxHeight(area.getMaxHeight() - n + this.blockArea.getMaxHeight());
                        area.increaseHeight(this.blockArea.getHeight());
                        area.setAbsoluteHeight(this.blockArea.getAbsoluteHeight());
                        this.anythingLaidOut = true;
                        return status;
                    }
                    this.anythingLaidOut = false;
                    return status;
                }
                area.addChild(this.blockArea);
                area.setMaxHeight(area.getMaxHeight() - n + this.blockArea.getMaxHeight());
                area.increaseHeight(this.blockArea.getHeight());
                area.setAbsoluteHeight(this.blockArea.getAbsoluteHeight());
                this.anythingLaidOut = true;
                return status;
            }
            this.anythingLaidOut = true;
            ++n7;
        }
        this.blockArea.end();
        area.addChild(this.blockArea);
        area.increaseHeight(this.blockArea.getHeight());
        area.setAbsoluteHeight(this.blockArea.getAbsoluteHeight());
        if (this.spaceAfter != 0) {
            area.addDisplaySpace(this.spaceAfter);
        }
        if (area instanceof BlockArea) {
            area.start();
        }
        if (this.breakAfter == 3) {
            this.marker = -1001;
            return new Status(4);
        }
        if (this.breakAfter == 5) {
            this.marker = -1001;
            return new Status(6);
        }
        if (this.breakAfter == 4) {
            this.marker = -1001;
            return new Status(5);
        }
        if (this.breakAfter == 2) {
            this.marker = -1001;
            return new Status(7);
        }
        if (this.keepWithNext != 0) {
            return new Status(8);
        }
        return new Status(1);
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new Block(fObj, propertyList);
        }
    }
}

