/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.datatypes.IDReferences;
import org.apache.fop.fo.FOText;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.FontState;
import org.apache.fop.layout.LineArea;
import org.apache.fop.layout.TextState;
import org.apache.fop.messaging.MessageHandler;

public class PageNumberCitation
extends FObj {
    FontState fs;
    float red;
    float green;
    float blue;
    int wrapOption;
    int whiteSpaceCollapse;
    Area area;
    String pageNumber;
    String refId;
    String id;
    TextState ts;

    public PageNumberCitation(FObj fObj, PropertyList propertyList) {
        super(fObj, propertyList);
        this.name = "fo:page-number-citation";
    }

    public Status layout(Area area) throws FOPException {
        Object object;
        Object object2;
        if (!(area instanceof BlockArea)) {
            MessageHandler.errorln("WARNING: page-number-citation outside block area");
            return new Status(1);
        }
        IDReferences iDReferences = area.getIDReferences();
        this.area = area;
        if (this.marker == -1000) {
            object2 = this.properties.get("font-family").getString();
            object = this.properties.get("font-style").getString();
            String string = this.properties.get("font-weight").getString();
            int n = this.properties.get("font-size").getLength().mvalue();
            int n2 = this.properties.get("font-variant").getEnum();
            this.fs = new FontState(area.getFontInfo(), (String)object2, (String)object, string, n, n2);
            ColorType colorType = this.properties.get("color").getColorType();
            this.red = colorType.red();
            this.green = colorType.green();
            this.blue = colorType.blue();
            this.wrapOption = this.properties.get("wrap-option").getEnum();
            this.whiteSpaceCollapse = this.properties.get("white-space-collapse").getEnum();
            this.refId = this.properties.get("ref-id").getString();
            if (this.refId.equals("")) {
                throw new FOPException("page-number-citation must contain \"ref-id\"");
            }
            this.id = this.properties.get("id").getString();
            iDReferences.createID(this.id);
            this.ts = new TextState();
            this.marker = 0;
        }
        if (this.marker == 0) {
            iDReferences.configureID(this.id, area);
        }
        this.pageNumber = iDReferences.getPageNumber(this.refId);
        if (this.pageNumber != null) {
            this.marker = FOText.addText((BlockArea)area, this.fs, this.red, this.green, this.blue, this.wrapOption, null, this.whiteSpaceCollapse, this.pageNumber.toCharArray(), 0, this.pageNumber.length(), this.ts, 1);
        } else {
            object2 = (BlockArea)area;
            object = ((BlockArea)object2).getCurrentLineArea();
            if (object == null) {
                return new Status(2);
            }
            ((LineArea)object).changeFont(this.fs);
            ((LineArea)object).changeColor(this.red, this.green, this.blue);
            ((LineArea)object).changeWrapOption(this.wrapOption);
            ((LineArea)object).changeWhiteSpaceCollapse(this.whiteSpaceCollapse);
            ((LineArea)object).addPageNumberCitation(this.refId, null);
            this.marker = -1;
        }
        if (this.marker == -1) {
            return new Status(1);
        }
        return new Status(2);
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new PageNumberCitation(fObj, propertyList);
        }
    }
}

