/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.pagination;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.pagination.Region;
import org.apache.fop.layout.BodyRegionArea;
import org.apache.fop.layout.RegionArea;
import org.apache.fop.messaging.MessageHandler;

public class RegionBody
extends Region {
    public static final String REGION_CLASS = "body";
    ColorType backgroundColor;

    protected RegionBody(FObj fObj, PropertyList propertyList) throws FOPException {
        super(fObj, propertyList);
    }

    protected String getDefaultRegionName() {
        return "xsl-region-body";
    }

    protected String getElementName() {
        return "fo:region-body";
    }

    public String getRegionClass() {
        return REGION_CLASS;
    }

    RegionArea makeRegionArea(int n, int n2, int n3, int n4) {
        int n5 = this.properties.get("margin-top").getLength().mvalue();
        int n6 = this.properties.get("margin-bottom").getLength().mvalue();
        int n7 = this.properties.get("margin-left").getLength().mvalue();
        int n8 = this.properties.get("margin-right").getLength().mvalue();
        this.backgroundColor = this.properties.get("background-color").getColorType();
        BodyRegionArea bodyRegionArea = new BodyRegionArea(n + n7, n2 - n5, n3 - n7 - n8, n4 - n5 - n6);
        int n9 = this.properties.get("overflow").getEnum();
        String string = this.properties.get("column-count").getString();
        int n10 = 1;
        try {
            n10 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            MessageHandler.errorln("Bad value on region body 'column-count'");
            n10 = 1;
        }
        if (n10 > 1 && n9 == 3) {
            MessageHandler.errorln("Setting 'column-count' to 1 because 'overflow' is set to 'scroll'");
            n10 = 1;
        }
        bodyRegionArea.setColumnCount(n10);
        int n11 = this.properties.get("column-gap").getLength().mvalue();
        bodyRegionArea.setColumnGap(n11);
        bodyRegionArea.setBackgroundColor(this.backgroundColor);
        return bodyRegionArea;
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new RegionBody(fObj, propertyList);
        }
    }
}

