/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.pagination;

import java.util.Vector;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.pagination.ConditionalPageMasterReference;
import org.apache.fop.fo.pagination.PageSequenceMaster;
import org.apache.fop.fo.pagination.SubSequenceSpecifier;

public class RepeatablePageMasterAlternatives
extends FObj
implements SubSequenceSpecifier {
    private static final int INFINITE = -1;
    private PageSequenceMaster pageSequenceMaster;
    private int maximumRepeats;
    private int numberConsumed = 0;
    private Vector conditionalPageMasterRefs;

    public RepeatablePageMasterAlternatives(FObj fObj, PropertyList propertyList) throws FOPException {
        super(fObj, propertyList);
        this.name = "fo:repeatable-page-master-alternatives";
        this.conditionalPageMasterRefs = new Vector();
        if (!fObj.getName().equals("fo:page-sequence-master")) {
            throw new FOPException("fo:repeatable-page-master-alternativesmust be child of fo:page-sequence-master, not " + fObj.getName());
        }
        this.pageSequenceMaster = (PageSequenceMaster)fObj;
        this.pageSequenceMaster.addSubsequenceSpecifier(this);
        String string = this.getProperty("maximum-repeats").getString();
        if (string.equals("no-limit")) {
            this.setMaximumRepeats(-1);
        } else {
            try {
                this.setMaximumRepeats(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                throw new FOPException("Invalid number for 'maximum-repeats' property");
            }
        }
    }

    public void addConditionalPageMasterReference(ConditionalPageMasterReference conditionalPageMasterReference) {
        this.conditionalPageMasterRefs.addElement(conditionalPageMasterReference);
    }

    private int getMaximumRepeats() {
        return this.maximumRepeats;
    }

    public String getNextPageMaster(int n, boolean bl, boolean bl2) {
        String string = null;
        if (this.getMaximumRepeats() != -1) {
            if (this.numberConsumed < this.getMaximumRepeats()) {
                ++this.numberConsumed;
            } else {
                return null;
            }
        }
        int n2 = 0;
        while (n2 < this.conditionalPageMasterRefs.size()) {
            ConditionalPageMasterReference conditionalPageMasterReference = (ConditionalPageMasterReference)this.conditionalPageMasterRefs.elementAt(n2);
            if (conditionalPageMasterReference.isValid(n + 1, bl, false)) {
                string = conditionalPageMasterReference.getMasterName();
                break;
            }
            ++n2;
        }
        return string;
    }

    protected PageSequenceMaster getPageSequenceMaster() {
        return this.pageSequenceMaster;
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    public void reset() {
        this.numberConsumed = 0;
    }

    private void setMaximumRepeats(int n) {
        this.maximumRepeats = n == -1 ? n : (n < 0 ? 0 : n);
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new RepeatablePageMasterAlternatives(fObj, propertyList);
        }
    }
}

