/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.apps;

import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.fop.fonts.PFMFile;
import org.apache.fop.tools.xslt.XSLTransform;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PFMReader {
    private static final String XSL_POSTPROCESS = "FontPostProcess.xsl";
    private static final String XSL_SORT = "FontPostProcessSort.xsl";
    private boolean invokedStandalone = false;

    public Document constructFontXML(PFMFile pFMFile, String string, String string2, String string3, String string4) {
        Object object;
        System.out.println("Creating xml font file...");
        System.out.println();
        DocumentImpl documentImpl = new DocumentImpl();
        Element element = documentImpl.createElement("font-metrics");
        documentImpl.appendChild(element);
        Element element2 = documentImpl.createElement("font-name");
        element.appendChild(element2);
        element2.appendChild(documentImpl.createTextNode(pFMFile.getPostscriptName()));
        String string5 = pFMFile.getPostscriptName();
        int n = string5.indexOf("-");
        if (n >= 0) {
            object = new char[string5.length() - 1];
            string5.getChars(0, n, (char[])object, 0);
            string5.getChars(n + 1, string5.length(), (char[])object, n);
            string5 = new String((char[])object);
        }
        element2 = documentImpl.createElement("class-name");
        element.appendChild(element2);
        if (string2 != null) {
            element2.appendChild(documentImpl.createTextNode(string2));
        } else {
            element2.appendChild(documentImpl.createTextNode(string5));
        }
        element2 = documentImpl.createElement("embedFile");
        element.appendChild(element2);
        if (string4 == null) {
            element2.appendChild(documentImpl.createTextNode("null"));
        } else {
            element2.appendChild(documentImpl.createTextNode("\"" + this.escapeString(string4) + "\""));
        }
        element2 = documentImpl.createElement("embedResource");
        element.appendChild(element2);
        if (string3 == null) {
            element2.appendChild(documentImpl.createTextNode("null"));
        } else {
            element2.appendChild(documentImpl.createTextNode("\"" + this.escapeString(string3) + "\""));
        }
        element2 = documentImpl.createElement("subtype");
        element.appendChild(element2);
        element2.appendChild(documentImpl.createTextNode("Type1"));
        element2 = documentImpl.createElement("encoding");
        element.appendChild(element2);
        element2.appendChild(documentImpl.createTextNode(String.valueOf(pFMFile.getCharSetName()) + "Encoding"));
        element2 = documentImpl.createElement("cap-height");
        element.appendChild(element2);
        object = new Integer(pFMFile.getCapHeight());
        element2.appendChild(documentImpl.createTextNode(((Integer)object).toString()));
        element2 = documentImpl.createElement("x-height");
        element.appendChild(element2);
        object = new Integer(pFMFile.getXHeight());
        element2.appendChild(documentImpl.createTextNode(((Integer)object).toString()));
        element2 = documentImpl.createElement("ascender");
        element.appendChild(element2);
        object = new Integer(pFMFile.getLowerCaseAscent());
        element2.appendChild(documentImpl.createTextNode(((Integer)object).toString()));
        element2 = documentImpl.createElement("descender");
        element.appendChild(element2);
        object = new Integer(-pFMFile.getLowerCaseDescent());
        element2.appendChild(documentImpl.createTextNode(((Integer)object).toString()));
        Element element3 = documentImpl.createElement("bbox");
        element.appendChild(element3);
        int[] nArray = pFMFile.getFontBBox();
        String[] stringArray = new String[]{"left", "bottom", "right", "top"};
        int n2 = 0;
        while (n2 < 4) {
            element2 = documentImpl.createElement(stringArray[n2]);
            element3.appendChild(element2);
            object = new Integer(nArray[n2]);
            element2.appendChild(documentImpl.createTextNode(((Integer)object).toString()));
            ++n2;
        }
        element2 = documentImpl.createElement("flags");
        element.appendChild(element2);
        object = new Integer(pFMFile.getFlags());
        element2.appendChild(documentImpl.createTextNode(((Integer)object).toString()));
        element2 = documentImpl.createElement("stemv");
        element.appendChild(element2);
        object = new Integer(pFMFile.getStemV());
        element2.appendChild(documentImpl.createTextNode(((Integer)object).toString()));
        element2 = documentImpl.createElement("italicangle");
        element.appendChild(element2);
        object = new Integer(pFMFile.getItalicAngle());
        element2.appendChild(documentImpl.createTextNode(((Integer)object).toString()));
        element2 = documentImpl.createElement("first-char");
        element.appendChild(element2);
        object = new Integer(pFMFile.getFirstChar());
        element2.appendChild(documentImpl.createTextNode(((Integer)object).toString()));
        element2 = documentImpl.createElement("last-char");
        element.appendChild(element2);
        object = new Integer(pFMFile.getLastChar());
        element2.appendChild(documentImpl.createTextNode(((Integer)object).toString()));
        Element element4 = documentImpl.createElement("widths");
        element.appendChild(element4);
        short s = pFMFile.getFirstChar();
        while (s < pFMFile.getLastChar()) {
            element2 = documentImpl.createElement("char");
            element4.appendChild(element2);
            element2.setAttribute("ansichar", "0x00" + Integer.toHexString(s).toUpperCase());
            element2.setAttribute("width", new Integer(pFMFile.getCharWidth(s)).toString());
            s = (short)(s + 1);
        }
        Enumeration enumeration = pFMFile.getKerning().keys();
        while (enumeration.hasMoreElements()) {
            String string6 = (String)enumeration.nextElement();
            element2 = documentImpl.createElement("kerning");
            element2.setAttribute("kpx1", string6);
            element.appendChild(element2);
            Element element5 = null;
            Hashtable hashtable = (Hashtable)pFMFile.getKerning().get(string6);
            Enumeration enumeration2 = hashtable.keys();
            while (enumeration2.hasMoreElements()) {
                String string7 = (String)enumeration2.nextElement();
                element5 = documentImpl.createElement("pair");
                element5.setAttribute("kpx2", string7);
                Integer n3 = (Integer)hashtable.get(string7);
                element5.setAttribute("kern", n3.toString());
                element2.appendChild(element5);
            }
        }
        return documentImpl;
    }

    private static final void displayUsage() {
        System.out.println(" java org.apache.fop.fonts.apps.PFMReader [options] metricfile.pfm xmlfile.xml\n");
        System.out.println(" where options can be:\n");
        System.out.println(" -fn <fontname>\n");
        System.out.println("     default is to use the fontname in the .pfm file, but you can override\n");
        System.out.println("     that name to make sure that the embedded font is used instead of installed\n");
        System.out.println("     fonts when viewing documents with Acrobat Reader.\n");
        System.out.println(" -cn <classname>\n");
        System.out.println("     default is to use the fontname\n");
        System.out.println(" -ef <path to the Type1 .pfb fontfile>\n");
        System.out.println("     will add the possibility to embed the font. When running fop, fop will look\n");
        System.out.println("     for this file to embed it\n");
        System.out.println(" -er <path to Type1 fontfile relative to org/apache/fop/render/pdf/fonts>\n");
        System.out.println("     you can also include the fontfile in the fop.jar file when building fop.\n");
        System.out.println("     You can use both -ef and -er. The file specified in -ef will be searched first,\n");
        System.out.println("     then the -er file.\n");
    }

    private String escapeString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) == '\\') {
                stringBuffer.append("\\\\");
            } else {
                stringBuffer.append(string.charAt(n));
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public PFMFile loadPFM(String string) {
        try {
            System.out.println("Reading " + string + "...");
            System.out.println();
            FileInputStream fileInputStream = new FileInputStream(string);
            PFMFile pFMFile = new PFMFile();
            pFMFile.load(fileInputStream);
            return pFMFile;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static void main(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        Hashtable hashtable = new Hashtable();
        String[] stringArray2 = PFMReader.parseArguments(hashtable, stringArray);
        PFMReader pFMReader = new PFMReader();
        pFMReader.invokedStandalone = true;
        System.out.println("PFM Reader v1.1");
        System.out.println();
        if (hashtable.get("-ef") != null) {
            string = (String)hashtable.get("-ef");
        }
        if (hashtable.get("-er") != null) {
            string2 = (String)hashtable.get("-er");
        }
        if (hashtable.get("-fn") != null) {
            string4 = (String)hashtable.get("-fn");
        }
        if (hashtable.get("-cn") != null) {
            string3 = (String)hashtable.get("-cn");
        }
        if (stringArray2.length != 2 || hashtable.get("-h") != null || hashtable.get("-help") != null || hashtable.get("--help") != null) {
            PFMReader.displayUsage();
        } else {
            PFMFile pFMFile = pFMReader.loadPFM(stringArray2[0]);
            if (pFMFile != null) {
                pFMReader.preview(pFMFile);
                Document document = pFMReader.constructFontXML(pFMFile, string4, string3, string2, string);
                document = pFMReader.postProcessXML(document);
                if (document != null) {
                    pFMReader.writeFontXML(document, stringArray2[1]);
                }
            }
        }
    }

    private static String[] parseArguments(Hashtable hashtable, String[] stringArray) {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].startsWith("-")) {
                if (++n < stringArray.length) {
                    hashtable.put(stringArray[n - 1], stringArray[n]);
                } else {
                    hashtable.put(stringArray[n - 1], "");
                }
            } else {
                vector.addElement(stringArray[n]);
            }
            ++n;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Document postProcessXML(Document document) {
        try {
            OutputFormat outputFormat = new OutputFormat(document);
            XMLSerializer xMLSerializer = new XMLSerializer((OutputStream)System.out, outputFormat);
            xMLSerializer.asDOMSerializer();
            xMLSerializer.serialize(document.getDocumentElement());
            System.out.println("Postprocessing...");
            System.out.println();
            InputStream inputStream = this.getClass().getResourceAsStream(XSL_POSTPROCESS);
            if (inputStream == null) {
                throw new Exception("Resource FontPostProcess.xsl not found");
            }
            DocumentImpl documentImpl = new DocumentImpl();
            XSLTransform.transform(document, inputStream, (Document)documentImpl);
            System.out.println("Sorting...");
            System.out.println();
            inputStream = this.getClass().getResourceAsStream(XSL_SORT);
            if (inputStream == null) {
                throw new Exception("Resource FontPostProcessSort.xsl not found");
            }
            DocumentImpl documentImpl2 = new DocumentImpl();
            XSLTransform.transform((Document)documentImpl, inputStream, (Document)documentImpl2);
            return documentImpl2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void preview(PFMFile pFMFile) {
        PrintStream printStream = System.out;
        printStream.print("Font: ");
        printStream.println(pFMFile.getWindowsName());
        printStream.print("Name: ");
        printStream.println(pFMFile.getPostscriptName());
        printStream.print("CharSet: ");
        printStream.println(pFMFile.getCharSetName());
        printStream.print("CapHeight: ");
        printStream.println(pFMFile.getCapHeight());
        printStream.print("XHeight: ");
        printStream.println(pFMFile.getXHeight());
        printStream.print("LowerCaseAscent: ");
        printStream.println(pFMFile.getLowerCaseAscent());
        printStream.print("LowerCaseDescent: ");
        printStream.println(pFMFile.getLowerCaseDescent());
        printStream.print("Having widths for ");
        printStream.print(pFMFile.getLastChar() - pFMFile.getFirstChar());
        printStream.print(" characters (");
        printStream.print(pFMFile.getFirstChar());
        printStream.print("-");
        printStream.print(pFMFile.getLastChar());
        printStream.println(").");
        printStream.print("for example: Char ");
        printStream.print(pFMFile.getFirstChar());
        printStream.print(" has a width of ");
        printStream.println(pFMFile.getCharWidth(pFMFile.getFirstChar()));
        printStream.println();
    }

    public void writeFontXML(Document document, String string) {
        System.out.println("Writing xml font file " + string + "...");
        System.out.println();
        try {
            OutputFormat outputFormat = new OutputFormat(document);
            FileWriter fileWriter = new FileWriter(string);
            XMLSerializer xMLSerializer = new XMLSerializer((Writer)fileWriter, outputFormat);
            xMLSerializer.asDOMSerializer();
            xMLSerializer.serialize(document.getDocumentElement());
            fileWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

