/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layout;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.IDReferences;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.flow.Block;
import org.apache.fop.fo.flow.BlockContainer;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AreaContainer;
import org.apache.fop.layout.FontState;
import org.apache.fop.layout.SpanArea;
import org.apache.fop.render.Renderer;

public class BodyAreaContainer
extends Area {
    private int xPosition;
    private int yPosition;
    private int position;
    private int columnCount;
    private int columnGap;
    private AreaContainer mainReferenceArea;
    private AreaContainer beforeFloatReferenceArea;
    private AreaContainer footnoteReferenceArea;
    private int mainRefAreaHeight;
    private int beforeFloatRefAreaHeight;
    private int footnoteRefAreaHeight;
    private int mainYPosition;
    private int beforeFloatYPosition;
    private int footnoteYPosition;
    private FObj startFO;
    private boolean isNewSpanArea;
    private int footnoteState = 0;
    private static int counter = 0;

    public BodyAreaContainer(FontState fontState, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(fontState, n3, n4);
        this.xPosition = n;
        this.yPosition = n2;
        this.position = n5;
        this.columnCount = n6;
        this.columnGap = n7;
        this.beforeFloatRefAreaHeight = 0;
        this.footnoteRefAreaHeight = 0;
        this.mainRefAreaHeight = n4 - this.beforeFloatRefAreaHeight - this.footnoteRefAreaHeight;
        this.beforeFloatReferenceArea = new AreaContainer(fontState, n, n2, n3, this.beforeFloatRefAreaHeight, 3);
        this.addChild(this.beforeFloatReferenceArea);
        this.mainReferenceArea = new AreaContainer(fontState, n, n2, n3, this.mainRefAreaHeight, 3);
        this.addChild(this.mainReferenceArea);
        int n8 = n2 - this.mainRefAreaHeight;
        this.footnoteReferenceArea = new AreaContainer(fontState, n, n8, n3, this.footnoteRefAreaHeight, 3);
        this.addChild(this.footnoteReferenceArea);
        this.setPadding(0, 0, 0, 0);
        this.setBorderWidth(0, 0, 0, 0);
    }

    private AreaContainer addSpanArea(int n) {
        this.resetHeights();
        int n2 = this.getYPosition() - this.mainReferenceArea.getContentHeight();
        SpanArea spanArea = new SpanArea(this.fontState, this.getXPosition(), n2, this.allocationWidth, this.getRemainingHeight(), n, this.columnGap);
        this.mainReferenceArea.addChild(spanArea);
        spanArea.setPage(this.getPage());
        this.isNewSpanArea = true;
        return spanArea.getCurrentColumnArea();
    }

    public void adjustFootnoteArea() {
        ++this.footnoteState;
        if (this.footnoteState == 1) {
            this.mainReferenceArea.setMaxHeight(this.footnoteReferenceArea.getYPosition() - this.mainYPosition);
            this.footnoteYPosition = this.footnoteReferenceArea.getYPosition();
            this.footnoteReferenceArea.setMaxHeight(this.footnoteReferenceArea.getHeight());
            Vector vector = this.footnoteReferenceArea.getChildren();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (!(e instanceof Area)) continue;
                Area area = (Area)e;
                this.footnoteReferenceArea.removeChild(area);
            }
            this.getPage().setPendingFootnotes(null);
        }
    }

    public AreaContainer getBeforeFloatReferenceArea() {
        return this.beforeFloatReferenceArea;
    }

    public AreaContainer getCurrentColumnArea() {
        Vector vector = this.mainReferenceArea.getChildren();
        SpanArea spanArea = (SpanArea)vector.elementAt(vector.size() - 1);
        return spanArea.getCurrentColumnArea();
    }

    public AreaContainer getFootnoteReferenceArea() {
        return this.footnoteReferenceArea;
    }

    public int getFootnoteState() {
        return this.footnoteState;
    }

    public IDReferences getIDReferences() {
        return this.mainReferenceArea.getIDReferences();
    }

    public AreaContainer getMainReferenceArea() {
        return this.mainReferenceArea;
    }

    public AreaContainer getNextArea(FObj fObj) throws FOPException {
        this.isNewSpanArea = false;
        int n = 1;
        if (fObj instanceof Block) {
            n = ((Block)fObj).getSpan();
        } else if (fObj instanceof BlockContainer) {
            n = ((BlockContainer)fObj).getSpan();
        }
        if (this.mainReferenceArea.getChildren().isEmpty()) {
            if (n == 2) {
                return this.addSpanArea(1);
            }
            return this.addSpanArea(this.columnCount);
        }
        Vector vector = this.mainReferenceArea.getChildren();
        SpanArea spanArea = (SpanArea)vector.elementAt(vector.size() - 1);
        if (n == 2 && spanArea.getColumnCount() == 1) {
            return spanArea.getCurrentColumnArea();
        }
        if (n == 1 && spanArea.getColumnCount() == this.columnCount) {
            return spanArea.getCurrentColumnArea();
        }
        if (n == 2) {
            return this.addSpanArea(1);
        }
        if (n == 1) {
            return this.addSpanArea(this.columnCount);
        }
        throw new FOPException("BodyAreaContainer::getNextArea(): Span attribute messed up");
    }

    public int getPosition() {
        return this.position;
    }

    public int getRemainingHeight() {
        return this.mainReferenceArea.getMaxHeight() - this.mainReferenceArea.getContentHeight();
    }

    public int getXPosition() {
        return this.xPosition + this.paddingLeft + this.borderWidthLeft;
    }

    public int getYPosition() {
        return this.yPosition + this.paddingTop + this.borderWidthTop;
    }

    public boolean isBalancingRequired(FObj fObj) {
        if (this.mainReferenceArea.getChildren().isEmpty()) {
            return false;
        }
        Vector vector = this.mainReferenceArea.getChildren();
        SpanArea spanArea = (SpanArea)vector.elementAt(vector.size() - 1);
        if (spanArea.isBalanced()) {
            return false;
        }
        int n = 1;
        if (fObj instanceof Block) {
            n = ((Block)fObj).getSpan();
        } else if (fObj instanceof BlockContainer) {
            n = ((BlockContainer)fObj).getSpan();
        }
        if (n == 2 && spanArea.getColumnCount() == 1) {
            return false;
        }
        if (n == 1 && spanArea.getColumnCount() == this.columnCount) {
            return false;
        }
        if (n == 2) {
            return true;
        }
        if (n == 1) {
            return false;
        }
        return false;
    }

    public boolean isLastColumn() {
        Vector vector = this.mainReferenceArea.getChildren();
        SpanArea spanArea = (SpanArea)vector.elementAt(vector.size() - 1);
        return spanArea.isLastColumn();
    }

    public boolean isNewSpanArea() {
        return this.isNewSpanArea;
    }

    public boolean needsFootnoteAdjusting() {
        this.footnoteYPosition = this.footnoteReferenceArea.getYPosition();
        switch (this.footnoteState) {
            case 0: {
                this.resetHeights();
                if (this.footnoteReferenceArea.getHeight() <= 0 || this.mainYPosition + this.mainReferenceArea.getHeight() <= this.footnoteYPosition) break;
                return true;
            }
        }
        return false;
    }

    public void render(Renderer renderer) {
        renderer.renderBodyAreaContainer(this);
    }

    private void resetHeights() {
        int n = 0;
        Enumeration enumeration = this.mainReferenceArea.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            int n2;
            SpanArea spanArea = (SpanArea)enumeration.nextElement();
            int n3 = spanArea.getMaxContentHeight();
            n += n3 < (n2 = spanArea.getMaxHeight()) ? n3 : n2;
        }
        this.mainReferenceArea.setHeight(n);
    }

    protected static void resetMaxHeight(Area area, int n) {
        area.setMaxHeight(n);
        Vector vector = area.getChildren();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof Area)) continue;
            Area area2 = (Area)e;
            BodyAreaContainer.resetMaxHeight(area2, n);
        }
    }

    public void resetSpanArea() {
        Vector vector = this.mainReferenceArea.getChildren();
        SpanArea spanArea = (SpanArea)vector.elementAt(vector.size() - 1);
        if (!spanArea.isBalanced()) {
            int n = spanArea.getTotalContentHeight() / spanArea.getColumnCount();
            this.mainReferenceArea.removeChild(spanArea);
            this.resetHeights();
            SpanArea spanArea2 = new SpanArea(this.fontState, this.getXPosition(), spanArea.getYPosition(), this.allocationWidth, n += 31200, spanArea.getColumnCount(), this.columnGap);
            this.mainReferenceArea.addChild(spanArea2);
            spanArea2.setPage(this.getPage());
            spanArea2.setIsBalanced();
            this.isNewSpanArea = true;
        } else {
            System.err.println("Trying to balance balanced area");
            System.exit(0);
        }
    }

    public void setIDReferences(IDReferences iDReferences) {
        this.mainReferenceArea.setIDReferences(iDReferences);
    }

    public void setXPosition(int n) {
        this.xPosition = n;
    }

    public void setYPosition(int n) {
        this.yPosition = n;
    }
}

