/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.mif;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.fop.messaging.MessageHandler;

public class MIFDocument {
    protected static final String mifVersion = "5.5";
    protected BookComponent bookComponent;
    private Flow curFlow;
    private ID curIDCounter = new ID();

    public MIFDocument() {
        this.bookComponent = new BookComponent();
    }

    public void addImage(String string, int n, int n2, int n3, int n4) {
        Frame frame = this.bookComponent.createFrame(n, n2, n3, n4);
        ImportObject importObject = new ImportObject(string, 0, 0, n3, n4);
        frame.addContent(importObject);
        if (this.curFlow.curPara().curParaLine() == null) {
            this.curFlow.curPara().startParaLine();
        }
        this.curFlow.curPara().curParaLine().addContent(frame);
    }

    public void addToStream(String string) {
        Para para = this.curFlow.curPara();
        ParaLine paraLine = para.curParaLine();
        paraLine.addContent(string);
    }

    public void createFrame(int n, int n2, int n3, int n4) {
        this.bookComponent.createFrame(n, n2, n3, n4);
    }

    public void createPage() {
        this.bookComponent.pages.addElement(new Page());
    }

    public void createTable() {
        Tbl tbl = this.bookComponent.createTable();
        if (this.curFlow.curPara().curParaLine() == null) {
            this.curFlow.curPara().startParaLine();
        }
        this.curFlow.curPara().curParaLine().addContent(tbl);
        this.curFlow = tbl;
    }

    public void createTextRect(int n) {
        this.bookComponent.curPage().addTextRect(n);
        this.curFlow = new TextFlow();
        this.bookComponent.textFlows.addElement(this.curFlow);
    }

    public void endTable() {
        this.curFlow = this.bookComponent.curTextFlow();
    }

    public void output(OutputStream outputStream) throws IOException {
        this.bookComponent.output(outputStream);
    }

    public void setBlockProp(int n, int n2) {
        this.curFlow.startPara();
        this.curFlow.curPara().setBlockProp(n, n2);
    }

    public void setColumnProp(int n) {
        Tbl tbl = this.bookComponent.curTable();
        tbl.addColumn(n);
    }

    public void setCurrent(String string) {
        Tbl tbl = this.bookComponent.curTable();
        tbl.setCurrent(string);
    }

    public void setDocumentHeightWidth(int n, int n2) {
        if (this.bookComponent.document == null) {
            this.bookComponent.document = new Document();
            this.bookComponent.document.height = n;
            this.bookComponent.document.width = n2;
        } else if (this.bookComponent.document.height != n || this.bookComponent.document.width != n2) {
            MessageHandler.logln("Warning : FrameMaker doesnt support different page-sizes \t\tin a document");
        }
    }

    public void setTextRectProp(int n, int n2, int n3, int n4) {
        this.bookComponent.curPage().curTextRect().setTextRectProp(n, n2, n3, n4);
    }

    public void startCell(int n, int n2) {
        Tbl tbl = this.bookComponent.curTable();
        tbl.startCell(n, n2);
    }

    public void startLine() {
        if (this.curFlow.curPara().curParaLine() != null) {
            this.addToStream("\n");
            this.curFlow.curPara().startParaLine();
        } else {
            this.curFlow.curPara().startParaLine();
        }
    }

    public void startRow() {
        Tbl tbl = this.bookComponent.curTable();
        tbl.startRow();
    }

    class ID {
        private int idCounter = 1;

        ID() {
        }

        public int getnewID() {
            return this.idCounter++;
        }
    }

    class FontFormat {
    }

    class ParagraphFormat
    extends FontFormat {
        int startIndent;
        int endIndent;
    }

    class Document {
        protected int height;
        protected int width;

        public void output(OutputStream outputStream) throws IOException {
            String string = "\n<Document \n<DPageSize " + (float)this.width / 1000.0f + " " + (float)this.height / 1000.0f + " >\n>";
            byte[] byArray = string.getBytes();
            outputStream.write(byArray);
        }
    }

    class PolyLine {
    }

    class ImportObject {
        private String url;
        private int x;
        private int y;
        private int w;
        private int h;

        public ImportObject(String string, int n, int n2, int n3, int n4) {
            this.url = string;
            this.x = n;
            this.y = n2;
            this.w = n3;
            this.h = n4;
        }

        public void output(OutputStream outputStream) throws IOException {
            int n;
            String string = this.url;
            string = string.substring(5);
            String string2 = "";
            do {
                if ((n = string.indexOf("/")) == -1) continue;
                string2 = string.substring(0, n);
                string2 = String.valueOf(string2) + "<c\\>";
                string = string2 = String.valueOf(string2) + string.substring(n + 1);
            } while (n != -1);
            String string3 = "\n<ImportObject\n<ImportObFixedSize Yes>";
            string3 = String.valueOf(string3) + "\n\t<ImportObFileDI `<c\\>" + string + "'" + " >";
            string3 = String.valueOf(string3) + "\n\t<ShapeRect " + (float)this.x / 1000.0f + " " + (float)this.y / 1000.0f + " " + (float)this.w / 1000.0f + " " + (float)this.h / 1000.0f + " >";
            string3 = String.valueOf(string3) + "\n> #End ImportObj";
            outputStream.write(string3.getBytes());
        }
    }

    class Frame {
        private int ID;
        private int x;
        private int y;
        private int w;
        private int h;
        Vector content = new Vector();

        public Frame(int n, int n2, int n3, int n4) {
            this.ID = MIFDocument.this.curIDCounter.getnewID();
            this.x = n;
            this.y = n2;
            this.w = n3;
            this.h = n4;
        }

        public void addContent(ImportObject importObject) {
            this.content.addElement(importObject);
        }

        public int getID() {
            return this.ID;
        }

        public void output(OutputStream outputStream) throws IOException {
            String string = "\n<Frame\n\t<ID " + this.ID + " >";
            string = String.valueOf(string) + "\n\t<Pen 15>\n\t<Fill 7>\n\t<PenWidth  1.0 >\n\t<Separation 0>\n\t<ObColor `Black'>\n\t<DashedPattern \n\t <DashedStyle Solid> \n >";
            string = String.valueOf(string) + "\n\t<RunaroundGap  6.0 pt>\n\t<RunaroundType None>\n\t<Angle  360.0>\n\t<Float No>\n\t<NSOffset  0.0>\n\t<BLOffset  0>\n\t<Cropped No>\n\t<FrameType Below>\n\t<AnchorAlign Center>";
            string = String.valueOf(string) + "\n\t<ShapeRect " + (float)this.x / 1000.0f + " " + (float)this.y / 1000.0f + " " + (float)this.w / 1000.0f + " " + (float)this.h / 1000.0f + " >";
            outputStream.write(string.getBytes());
            Enumeration enumeration = this.content.elements();
            while (enumeration.hasMoreElements()) {
                ((ImportObject)enumeration.nextElement()).output(outputStream);
            }
            string = "\n> #End Frame";
            outputStream.write(string.getBytes());
        }
    }

    class TextRect {
        private int rx;
        private int ry;
        private int w;
        private int h;
        private int numCols;
        private int curCol = 0;
        private int colGap = 0;
        private int textRectID;

        public TextRect(int n) {
            this.numCols = n;
            this.curCol = 0;
            this.textRectID = MIFDocument.this.curIDCounter.getnewID();
        }

        public int getTextRectID() {
            return this.textRectID;
        }

        public void output(OutputStream outputStream) throws IOException {
            String string = "\n<TextRect\n\t<ID " + this.textRectID + ">" + "\n\t<ShapeRect " + (float)this.rx / 1000.0f + " " + (float)this.ry / 1000.0f + " " + (float)this.w / 1000.0f + " " + (float)this.h / 1000.0f + ">";
            if (this.numCols > 1) {
                string = String.valueOf(string) + "\n<TRNumColumns " + this.numCols + ">";
                string = String.valueOf(string) + "\n<TRColumnGap " + (float)this.colGap / 1000.0f + ">";
            }
            string = String.valueOf(string) + "\n> #End TextRect";
            byte[] byArray = string.getBytes();
            outputStream.write(byArray);
        }

        public void setTextRectProp(int n, int n2, int n3, int n4) {
            if (this.curCol == 0) {
                this.rx = n;
                this.ry = n2;
                this.w = n3;
                this.h = n4;
                ++this.curCol;
            } else if (this.curCol == 1) {
                this.colGap = n - this.rx - n3;
                this.w = this.numCols * n3 + (this.numCols - 1) * this.colGap;
                ++this.curCol;
            }
        }
    }

    class Page {
        private String pageType;
        private String pageTag;
        private String pageBackground;
        private Vector textRects;

        public Page() {
            this.pageType = "BodyPage";
            this.pageBackground = "Default";
            this.textRects = new Vector();
        }

        public Page(String string, String string2, String string3) {
            this.pageType = string;
            this.pageTag = string2;
            this.pageBackground = string3;
            this.textRects = new Vector();
        }

        public void addTextRect(int n) {
            TextRect textRect = new TextRect(n);
            this.textRects.addElement(textRect);
        }

        public TextRect curTextRect() {
            return (TextRect)this.textRects.lastElement();
        }

        public void output(OutputStream outputStream) throws IOException {
            String string = "\n<Page\n\t<PageType " + this.pageType + ">" + "\n\t<PageBackground " + "`" + this.pageBackground + "'" + ">";
            byte[] byArray = string.getBytes();
            outputStream.write(byArray);
            Enumeration enumeration = this.textRects.elements();
            while (enumeration.hasMoreElements()) {
                ((TextRect)enumeration.nextElement()).output(outputStream);
            }
            string = "\n>  #End Page\n";
            outputStream.write(string.getBytes());
        }
    }

    abstract class Flow {
        public abstract Para curPara();

        public abstract void startPara();
    }

    class TextFlow
    extends Flow {
        Vector paras;
        private int ID;

        public TextFlow() {
            this.ID = MIFDocument.this.bookComponent.curPage().curTextRect().getTextRectID();
            this.paras = new Vector();
        }

        public Para curPara() {
            return (Para)this.paras.lastElement();
        }

        public int getTextRectID() {
            return this.ID;
        }

        public void output(OutputStream outputStream) throws IOException {
            String string = "\n<TextFlow";
            outputStream.write(string.getBytes());
            Enumeration enumeration = this.paras.elements();
            while (enumeration.hasMoreElements()) {
                ((Para)enumeration.nextElement()).output(outputStream);
            }
            string = "\n> #End TextFlow";
            outputStream.write(string.getBytes());
        }

        public void startPara() {
            this.paras.addElement(new Para(this.ID));
        }
    }

    class Para {
        Vector paraLines;
        int ID;
        ParagraphFormat pgf = null;

        public Para() {
            this.ID = 0;
            this.paraLines = new Vector();
        }

        public Para(int n) {
            this.ID = n;
            this.paraLines = new Vector();
        }

        public ParaLine curParaLine() {
            if (this.paraLines.isEmpty()) {
                return null;
            }
            return (ParaLine)this.paraLines.lastElement();
        }

        public void output(OutputStream outputStream) throws IOException {
            String string = "\n<Para";
            if (this.pgf != null) {
                string = String.valueOf(string) + "\n<Pgf";
                string = String.valueOf(string) + "\n<PgfTag `Body'>";
                string = String.valueOf(string) + "\n<PgfLIndent " + (float)this.pgf.startIndent / 1000.0f + ">";
                string = String.valueOf(string) + "\n<PgfRIndent " + (float)this.pgf.endIndent / 1000.0f + ">";
                string = String.valueOf(string) + "\n>";
            }
            outputStream.write(string.getBytes());
            Enumeration enumeration = this.paraLines.elements();
            while (enumeration.hasMoreElements()) {
                ((ParaLine)enumeration.nextElement()).output(outputStream);
            }
            string = "\n> #End ParaLine";
            outputStream.write(string.getBytes());
        }

        public void setBlockProp(int n, int n2) {
            this.pgf = new ParagraphFormat();
            this.pgf.startIndent = n;
            this.pgf.endIndent = n2;
        }

        void startParaLine() {
            this.paraLines.addElement(new ParaLine(this.ID));
        }
    }

    class ParaLine {
        Vector content;
        int textRectID;
        String tableID;
        String aFrameID;

        public ParaLine() {
            this.textRectID = 0;
            this.content = new Vector();
        }

        public ParaLine(int n) {
            this.textRectID = n;
            this.content = new Vector();
        }

        public void addContent(Object object) {
            this.content.addElement(object);
        }

        public void output(OutputStream outputStream) throws IOException {
            String string = "\n<ParaLine";
            if (this.textRectID != 0) {
                string = String.valueOf(string) + "\n\t<TextRectID " + this.textRectID + ">";
            }
            outputStream.write(string.getBytes());
            Enumeration enumeration = this.content.elements();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (e instanceof String) {
                    string = e == "\n" ? "\n<Char HardReturn>" : "\n\t<String `" + e + "'>";
                    outputStream.write(string.getBytes());
                    continue;
                }
                if (e instanceof Frame) {
                    string = "\n\t<AFrame " + ((Frame)e).getID() + " >";
                    outputStream.write(string.getBytes());
                    continue;
                }
                if (!(e instanceof Tbl)) continue;
                string = "\n\t<ATbl " + ((Tbl)e).getID() + " >";
                outputStream.write(string.getBytes());
            }
            string = "\n> #End ParaLine";
            outputStream.write(string.getBytes());
        }
    }

    class PgfCatalog {
        Vector pgfs;

        public void output(OutputStream outputStream) throws IOException {
            String string = "\n<PgfCatalog\n<Pgf\n<PgfTag `Body'>\n>\n>";
            outputStream.write(string.getBytes());
        }
    }

    class Color {
    }

    class ColorCatalog {
    }

    class Ruling {
        int penWidth = 1;
        int pen = 0;
        int lines = 1;

        public void output(OutputStream outputStream) throws IOException {
            String string = "\n<Ruling \n<RulingTag `Default'>";
            string = String.valueOf(string) + "\n<RulingPenWidth " + this.penWidth + ">";
            string = String.valueOf(string) + "\n<RulingPen " + this.pen + ">";
            string = String.valueOf(string) + "\n<RulingLines " + this.lines + ">";
            string = String.valueOf(string) + "\n>";
            outputStream.write(string.getBytes());
        }
    }

    class RulingCatalog {
        Vector ruling = new Vector();

        public RulingCatalog() {
            this.ruling.addElement(new Ruling());
        }

        public void output(OutputStream outputStream) throws IOException {
            String string = "\n<RulingCatalog";
            outputStream.write(string.getBytes());
            Enumeration enumeration = this.ruling.elements();
            while (enumeration.hasMoreElements()) {
                ((Ruling)enumeration.nextElement()).output(outputStream);
            }
            string = "\n> #End RulingCatalog";
            outputStream.write(string.getBytes());
        }
    }

    class TblFormat {
    }

    class TblCatalog {
    }

    class Tbl
    extends Flow {
        private int ID;
        private Vector tblColumns = new Vector();
        private Vector tblBody;
        private Vector tblHead;
        private Vector tblFoot;
        private Vector current;

        public Tbl() {
            this.ID = MIFDocument.this.curIDCounter.getnewID();
            this.tblBody = new Vector();
            this.tblHead = new Vector();
            this.tblFoot = new Vector();
        }

        public void addColumn(int n) {
            this.tblColumns.addElement(new TblColumn(n));
        }

        public Para curPara() {
            Row row = (Row)this.current.lastElement();
            return (Para)row.curCell().paras.lastElement();
        }

        public int getID() {
            return this.ID;
        }

        public void output(OutputStream outputStream) throws IOException {
            Enumeration enumeration;
            String string = "\n<Tbl\n\t<TblID " + this.ID + " >";
            string = String.valueOf(string) + "\n<TblTag Body>\n<TblFormat";
            string = String.valueOf(string) + "\n<TblColumnRuling `Default'>";
            string = String.valueOf(string) + "\n<TblBodyRowRuling `Default'>";
            string = String.valueOf(string) + "\n<TblLRuling `Default'>";
            string = String.valueOf(string) + "\n<TblBRuling `Default'>";
            string = String.valueOf(string) + "\n<TblRRuling `Default'>";
            string = String.valueOf(string) + "\n<TblTRuling `Default'>";
            string = String.valueOf(string) + "\n> #End TblFormat";
            string = String.valueOf(string) + "\n\t<TblNumColumns " + this.tblColumns.size() + " >";
            outputStream.write(string.getBytes());
            if (!this.tblHead.isEmpty()) {
                enumeration = this.tblHead.elements();
                while (enumeration.hasMoreElements()) {
                    ((Row)enumeration.nextElement()).output(outputStream);
                }
            }
            if (!this.tblFoot.isEmpty()) {
                enumeration = this.tblFoot.elements();
                while (enumeration.hasMoreElements()) {
                    ((Row)enumeration.nextElement()).output(outputStream);
                }
            }
            if (!this.tblBody.isEmpty()) {
                string = "\n\t<TblBody";
                outputStream.write(string.getBytes());
                enumeration = this.tblBody.elements();
                while (enumeration.hasMoreElements()) {
                    ((Row)enumeration.nextElement()).output(outputStream);
                }
                string = "\n\t> #End tblBody";
            }
            string = String.valueOf(string) + "\n> #End Table";
            outputStream.write(string.getBytes());
        }

        public void setCurrent(String string) {
            if (string == "fo:table-body") {
                this.current = this.tblBody;
            } else if (string == "tablehead") {
                this.current = this.tblHead;
            } else if (string == "tablefoot") {
                this.current = this.tblFoot;
            }
        }

        public void startCell(int n, int n2) {
            ((Row)this.current.lastElement()).addCell(n, n2);
        }

        public void startPara() {
            Row row = (Row)this.current.lastElement();
            row.curCell().startPara();
        }

        public void startRow() {
            this.current.addElement(new Row());
        }

        class TblColumn {
            private int width;

            public TblColumn(int n) {
                this.width = n;
            }

            public void output(OutputStream outputStream) throws IOException {
                String string = "\n\t<TblColumnWidth " + this.width + " >";
                outputStream.write(string.getBytes());
            }
        }

        class Row {
            private Vector cells = new Vector();

            public void addCell(int n, int n2) {
                this.cells.addElement(new Cell(n, n2));
            }

            public Cell curCell() {
                return (Cell)this.cells.lastElement();
            }

            public void output(OutputStream outputStream) throws IOException {
                String string = "\n\t<Row";
                outputStream.write(string.getBytes());
                Enumeration enumeration = this.cells.elements();
                while (enumeration.hasMoreElements()) {
                    ((Cell)enumeration.nextElement()).output(outputStream);
                }
                string = "\n\t> #End Row";
                outputStream.write(string.getBytes());
            }

            class Cell {
                private int rowSpan;
                private int colSpan;
                private Vector paras;

                public Cell(int n, int n2) {
                    this.rowSpan = n;
                    this.colSpan = n2;
                    this.paras = new Vector();
                }

                public void output(OutputStream outputStream) throws IOException {
                    String string = "\n\t\t<Cell\n\t\t<CellContent";
                    outputStream.write(string.getBytes());
                    Enumeration enumeration = this.paras.elements();
                    while (enumeration.hasMoreElements()) {
                        ((Para)enumeration.nextElement()).output(outputStream);
                    }
                    string = "\n\t\t> #End CellContent";
                    string = String.valueOf(string) + "\n\t> #End Cell";
                    outputStream.write(string.getBytes());
                }

                public void startPara() {
                    this.paras.addElement(new Para());
                }
            }
        }
    }

    class XRefFormat {
    }

    class CrossRefInfo {
    }

    class XRef {
    }

    class Marker {
    }

    class BookComponent {
        Document document = null;
        ColorCatalog colorCatalog;
        RulingCatalog rulingCatalog;
        PgfCatalog pgfCatalog;
        TblCatalog tblCatalog;
        Vector aFrames = new Vector();
        Vector tables = new Vector();
        Vector pages = new Vector();
        Vector textFlows = new Vector();

        public BookComponent() {
            this.pgfCatalog = new PgfCatalog();
            this.rulingCatalog = new RulingCatalog();
        }

        public Frame createFrame(int n, int n2, int n3, int n4) {
            Frame frame = new Frame(n, n2, n3, n4);
            this.aFrames.addElement(frame);
            return frame;
        }

        public Tbl createTable() {
            Tbl tbl = new Tbl();
            this.tables.addElement(tbl);
            return tbl;
        }

        public Frame curFrame() {
            return (Frame)this.aFrames.lastElement();
        }

        private Page curPage() {
            return (Page)this.pages.lastElement();
        }

        public Tbl curTable() {
            return (Tbl)this.tables.lastElement();
        }

        public TextFlow curTextFlow() {
            return (TextFlow)this.textFlows.lastElement();
        }

        public void output(OutputStream outputStream) throws IOException {
            Enumeration enumeration;
            String string = "<MIFFile 5.00>\n<Units Upt>";
            outputStream.write(string.getBytes());
            this.pgfCatalog.output(outputStream);
            this.rulingCatalog.output(outputStream);
            this.document.output(outputStream);
            if (!this.aFrames.isEmpty()) {
                string = "\n<AFrames";
                outputStream.write(string.getBytes());
                enumeration = this.aFrames.elements();
                while (enumeration.hasMoreElements()) {
                    ((Frame)enumeration.nextElement()).output(outputStream);
                }
                string = "\n>";
                outputStream.write(string.getBytes());
            }
            if (!this.tables.isEmpty()) {
                string = "\n<Tbls";
                outputStream.write(string.getBytes());
                enumeration = this.tables.elements();
                while (enumeration.hasMoreElements()) {
                    ((Tbl)enumeration.nextElement()).output(outputStream);
                }
                string = "\n>";
                outputStream.write(string.getBytes());
            }
            enumeration = this.pages.elements();
            while (enumeration.hasMoreElements()) {
                ((Page)enumeration.nextElement()).output(outputStream);
            }
            enumeration = this.textFlows.elements();
            while (enumeration.hasMoreElements()) {
                ((TextFlow)enumeration.nextElement()).output(outputStream);
            }
        }
    }

    class ElementSet {
    }
}

