/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.ant;

import fr.jayasoft.ivy.Ivy;
import fr.jayasoft.ivy.ModuleId;
import fr.jayasoft.ivy.ant.IvyTask;
import java.io.File;
import org.apache.tools.ant.BuildException;

public class IvyRetrieve
extends IvyTask {
    private String _organisation;
    private String _module;
    private String _conf;
    private File _cache;
    private String _pattern;
    private boolean _haltOnFailure = true;

    public File getCache() {
        return this._cache;
    }

    public void setCache(File cache) {
        this._cache = cache;
    }

    public String getConf() {
        return this._conf;
    }

    public void setConf(String conf) {
        this._conf = conf;
    }

    public String getModule() {
        return this._module;
    }

    public void setModule(String module) {
        this._module = module;
    }

    public String getOrganisation() {
        return this._organisation;
    }

    public void setOrganisation(String organisation) {
        this._organisation = organisation;
    }

    public String getPattern() {
        return this._pattern;
    }

    public void setPattern(String pattern) {
        this._pattern = pattern;
    }

    public boolean isHaltonfailure() {
        return this._haltOnFailure;
    }

    public void setHaltonfailure(boolean haltOnFailure) {
        this._haltOnFailure = haltOnFailure;
    }

    public void execute() throws BuildException {
        Ivy ivy = this.getIvyInstance();
        this._organisation = this.getProperty(this._organisation, ivy, "ivy.organisation");
        this._module = this.getProperty(this._module, ivy, "ivy.module");
        this.ensureResolved(this.isHaltonfailure(), this.getOrganisation(), this.getModule());
        this._organisation = this.getProperty(this._organisation, ivy, "ivy.organisation");
        this._module = this.getProperty(this._module, ivy, "ivy.module");
        if (this._cache == null) {
            this._cache = ivy.getDefaultCache();
        }
        this._pattern = this.getProperty(this._pattern, ivy, "ivy.retrieve.pattern");
        this._conf = this.getProperty(this._conf, ivy, "ivy.resolved.configurations");
        if ("*".equals(this._conf)) {
            this._conf = this.getProperty(ivy, "ivy.resolved.configurations");
            if (this._conf == null) {
                throw new BuildException("bad provided for ivy retrieve task: * can only be used with a prior call to <resolve/>");
            }
        }
        if (this._organisation == null) {
            throw new BuildException("no organisation provided for ivy retrieve task: It can either be set explicitely via the attribute 'organisation' or via 'ivy.organisation' property or a prior call to <resolve/>");
        }
        if (this._module == null) {
            throw new BuildException("no module name provided for ivy retrieve task: It can either be set explicitely via the attribute 'module' or via 'ivy.module' property or a prior call to <resolve/>");
        }
        if (this._conf == null) {
            throw new BuildException("no conf provided for ivy retrieve task: It can either be set explicitely via the attribute 'conf' or via 'ivy.resolved.configurations' property or a prior call to <resolve/>");
        }
        try {
            ivy.retrieve(new ModuleId(this._organisation, this._module), this.splitConfs(this._conf), this._cache, this._pattern);
        }
        catch (Exception ex) {
            throw new BuildException("impossible to ivy retrieve: " + ex.getMessage(), (Throwable)ex);
        }
    }
}

