/*  $Id: Command.cpp,v 1.9 2005/03/13 04:03:26 sarrazip Exp $
    Command.cpp - Abstract command-line driver

    verbiste - French conjugation system
    Copyright (C) 2003-2005 Pierre Sarrazin <http://sarrazip.com/>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
    02111-1307, USA.
*/

#include "Command.h"

#include <iostream>

using namespace std;
using namespace verbiste;


namespace verbiste {


Command::Command() throw (logic_error)
{
    fvd = new FrenchVerbDictionary();
}


Command::~Command()
{
    delete fvd;
}


int
Command::run(int argc, char *argv[]) throw()
{
    int optind = 0;
    bool useArgs = (optind < argc);

    try
    {
	if (fvd == NULL)
	    throw logic_error("fvd is NULL");

	for (;;)
	{
	    string latin1InputWord;

	    if (useArgs)
	    {
		if (optind == argc)
		    break;

		latin1InputWord = argv[optind];
		optind++;
	    }
	    else
	    {
		if (!getline(cin, latin1InputWord))
		    break;
	    }


	    // Source is assumed to be in ISO-8859-1; convert it to lower-case.
	    processInputWord(fvd->tolowerLatin1(latin1InputWord));
	}
    }
    catch (const exception &e)
    {
	cerr << "Exception: " << e.what() << endl;
	return EXIT_FAILURE;
    }

    return EXIT_SUCCESS;
}


const FrenchVerbDictionary &
Command::getFrenchVerbDictionary() const throw (logic_error)
{
    if (fvd == NULL)
	throw logic_error("fvd is NULL");
    return *fvd;
}


FrenchVerbDictionary &
Command::getFrenchVerbDictionary() throw (logic_error)
{
    if (fvd == NULL)
	throw logic_error("fvd is NULL");
    return *fvd;
}


}  // namespace verbiste
