/*
 * Copyright (c) 1998-2000 Stephen Williams (steve@icarus.com)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */
#if !defined(WINNT) && !defined(macintosh)
#ident "$Id: vvm_pevent.cc,v 1.10 2001/07/25 03:10:51 steve Exp $"
#endif

# include "config.h"

# include  "vvm.h"
# include  "vvm_gates.h"
# include  "vvm_thread.h"

vvm_sync::vvm_sync()
: hold_(0), tgt_(0), ntgt_(0)
{
}

void vvm_sync::wait(vvm_thread*thr)
{
      assert(thr->sync_back_ == 0);
      thr->sync_next_ = hold_;
      thr->sync_back_ = this;
      hold_ = thr;
}

void vvm_sync::wakeup()
{
      while (hold_) {
	    vvm_thread*tmp = hold_;
	    hold_ = tmp->sync_next_;
	    assert(tmp->sync_back_ == this);
	    tmp->sync_back_ = 0;
	    tmp->thread_yield();

	    for (unsigned idx = 0 ;  idx < ntgt_ ;  idx += 1)
		  tgt_[idx]->wakeup();
      }
}

void vvm_sync::chain_sync(vvm_sync*src)
{
      if (src->ntgt_ == 0) {
	    src->tgt_ = new vvm_sync*[1];
	    src->tgt_[0] = this;
	    src->ntgt_ = 1;

      } else {
	    vvm_sync**tmp = new vvm_sync*[src->ntgt_+1];
	    for (unsigned idx = 0 ;  idx < src->ntgt_ ;  idx += 1)
		  tmp[idx] = src->tgt_[idx];

	    tmp[src->ntgt_] = this;
	    src->ntgt_ += 1;
	    delete [] src->tgt_;
	    src->tgt_ = tmp;
      }
}

vvm_posedge::vvm_posedge(vvm_sync*tgt)
: sync_(tgt)
{
      val_ = StX;
}

vvm_posedge::~vvm_posedge()
{
}

void vvm_posedge::init_P(int, vpip_bit_t val)
{
      val_ = val;
}

void vvm_posedge::take_value(unsigned, vpip_bit_t val)
{
      if (val == val_)
	    return;

      if (posedge(val_, val))
	    sync_->wakeup();

      val_ = val;
}


vvm_negedge::vvm_negedge(vvm_sync*tgt)
: sync_(tgt)
{
      val_ = StX;
}

vvm_negedge::~vvm_negedge()
{
}

void vvm_negedge::init_P(int, vpip_bit_t val)
{
      val_ = val;
}

void vvm_negedge::take_value(unsigned, vpip_bit_t val)
{
      if (val == val_)
	    return;

      if (negedge(val_, val))
	    sync_->wakeup();

      val_ = val;
}

vvm_anyedge::vvm_anyedge(vvm_sync*tgt, unsigned n)
: nval_(n), sync_(tgt)
{
      val_ = new vpip_bit_t[nval_];
      for (unsigned idx = 0 ;  idx < nval_ ;  idx += 1)
	    val_[idx] = StX;
}

vvm_anyedge::~vvm_anyedge()
{
      delete[]val_;
}

void vvm_anyedge::init_P(unsigned key, vpip_bit_t val)
{
      assert(key < nval_);
      val_[key] = val;
}

void vvm_anyedge::take_value(unsigned key, vpip_bit_t val)
{
      assert(key < nval_);
      if (val == val_[key])
	    return;

      if (! B_EQ(val, val_[key]))
	    sync_->wakeup();

      val_[key] = val;
}


/*
 * $Log: vvm_pevent.cc,v $
 * Revision 1.10  2001/07/25 03:10:51  steve
 *  Create a config.h.in file to hold all the config
 *  junk, and support gcc 3.0. (Stephan Boettcher)
 *
 * Revision 1.9  2000/04/15 02:25:32  steve
 *  Support chained events.
 *
 * Revision 1.8  2000/04/12 16:08:46  steve
 *  Backwards sense of assert test.
 *
 * Revision 1.7  2000/04/12 01:53:07  steve
 *  Multiple thread can block on an event.
 *
 * Revision 1.6  2000/04/10 05:26:07  steve
 *  All events now use the NetEvent class.
 *
 * Revision 1.5  2000/02/23 02:56:57  steve
 *  Macintosh compilers do not support ident.
 *
 * Revision 1.4  1999/12/12 19:47:54  steve
 *  Remove the useless vvm_simulation class.
 *
 * Revision 1.3  1999/05/01 20:43:55  steve
 *  Handle wide events, such as @(a) where a has
 *  many bits in it.
 *
 *  Add to vvm the binary ^ and unary & operators.
 *
 *  Dump events a bit more completely.
 *
 * Revision 1.2  1999/05/01 02:57:53  steve
 *  Handle much more complex event expressions.
 *
 * Revision 1.1  1998/11/09 23:44:11  steve
 *  Add vvm library.
 *
 */

