/*
                             Progress Dialog
 */

#ifndef PROGRESSDIALOG_H
#define PROGRESSDIALOG_H

#include <sys/types.h>
#include <gtk/gtk.h>

#ifndef gbool
# define gbool	guchar
#endif


extern gint ProgressDialogInit(void);
extern void ProgressDialogSetTransientFor(GtkWidget *w);
extern gbool ProgressDialogIsQuery(void);	/* Checks if mapped. */
extern void ProgressDialogBreakQuery(gbool allow_gtk_iteration);
extern gint ProgressDialogStopCount(void);
extern void ProgressDialogMap(
        const gchar *title,
        const gchar *label,
	const u_int8_t **icon_data,
        const gchar *stop_btn_label
);
extern void ProgressDialogMapAnimation(
        const gchar *title,
        const gchar *label,
        const gchar *stop_btn_label,
        u_int8_t ***start_icon_data, gint total_start_icon_datas,
        u_int8_t ***icon_data, gint total_icon_datas,
        u_int8_t ***end_icon_data, gint total_end_icon_datas,
	glong animation_interval,	/* In ms, default is 500 ms. */
	guint16 animation_increment	/* Positive value up to (guint16)-1. */
);
extern void ProgressDialogUpdate(
	const gchar *title,
	const gchar *label,
	const u_int8_t **icon_data,
	const gchar *stop_btn_label,
	gdouble position,		/* 0.0 to 1.0. */
	guint nblocks,			/* 0 for continuous. */
	gbool allow_gtk_iteration
);
extern void ProgressDialogUpdateUnknown(
        const gchar *title,
        const gchar *label,
	const u_int8_t **icon_data,
        const gchar *stop_btn_label,
        gbool allow_gtk_iteration
);
extern void ProgressDialogUnmap(void);
extern void ProgressDialogShutdown(void);


#endif	/* PROGRESSDIALOG_H */
