/*
              Vertex Model Assembler - Basic Data Types

	These are basic data types like position and color structures
	uesd by Vertex.
 */

#ifndef VMATYPES_H
#define VMATYPES_H

#include <sys/types.h>
#include <gtk/gtk.h>

/*
 *	Color structure:
 */
typedef struct {

	gdouble a, r, g, b;

} vma_color_struct;

/*
 *	Light structure:
 */
typedef struct {

	guint flags;		/* Any of VMA_LIGHT_FLAG_*. */
#define VMA_LIGHT_FLAG_ENABLED	(1 << 0)

	gdouble x, y, z;		/* Position. */
	gdouble heading, pitch, bank;	/* Direction in radians. */

	/* Color. */
	vma_color_struct	ambient,
				diffuse,
				specular;

	/* Spot values. */
	gdouble spot_exponent;
	gdouble spot_cutoff;	/* In radians [0, PI]. If < (0.5 * PI)
				 * then implies omnidirectional.
				 */

	/* Attenuation values. */
	gdouble	attenuation_constant,
		attenuation_linear,
		attenuation_quadratic;

} vma_light_struct;




#endif	/* VMATYPES_H */
