/*
			    Color Selection Dialog
 */

#ifndef CSD_H
#define CSD_H

#include <gtk/gtk.h>

/*
 *	Color Selection Dialog Color structure:
 */
typedef struct {

	gfloat r, g, b, a;	/* 0.0 to 1.0 */

} csd_color_struct;


extern gint CSDInit(void);
extern void CSDSetStyle(GtkRcStyle *rc_style);
extern void CSDSetTransientFor(GtkWidget *w);
extern gboolean CSDIsQuery(void);
extern void CSDBreakQuery(void);
extern gboolean CSDGetResponse(
	const gchar *title,
	const gchar *ok_label, const gchar *cancel_label,
	csd_color_struct *start_color,
	csd_color_struct **color_rtn,
	gpointer client_data,
	void (*color_changed_cb)(gpointer, csd_color_struct *)
);
extern void CSDMap(void);
extern void CSDUnmap(void);
extern void CSDShutdown(void);

extern GtkWidget *CSDColorButtonNew(
	const gchar *label, gint label_width,
	gpointer client_data,
	void (*func_cb)(GtkWidget *, gpointer)
);
extern GtkWidget *CSDColorButtonNewSimple(const gchar *label, gint label_width);
extern GtkWidget *CSDColorButtonGetButton(GtkWidget *w);
extern void CSDColorButtonGetColor(GtkWidget *w, csd_color_struct *c);
extern void CSDColorButtonSetColor(GtkWidget *w, const csd_color_struct *c);

#endif	/* CSD_H */
