/*
			 VMA Editor - Callbacks
 */

#ifndef EDITORCB_H
#define EDITORCB_H


#include <gtk/gtk.h>

#include "view.h"
#include "editor.h"


extern void EditorSetWriteProtect(
	ma_editor_struct *editor,
	gbool state
);
extern void EditorRecordPositionsCB(ma_editor_struct *editor);

extern gint EditorEventCB(GtkWidget *widget, void *event, gpointer data);

extern void EditorDestroyCB(GtkObject *object, gpointer data);
extern gint EditorCloseCB(GtkWidget *widget, GdkEvent *event, gpointer data);
extern void EditorCloseMCB(GtkWidget *widget, gpointer data);
extern void EditorCloseAllMCB(GtkWidget *widget, gpointer data);

extern gint EditorMenuItemEnterCB(
	GtkWidget *widget, GdkEvent *event, gpointer data
);
extern void EditorNewFileCB(GtkWidget *widget, gpointer data);
extern void EditorOpenFileCB(GtkWidget *widget, gpointer data);
extern void EditorSaveFileCB(GtkWidget *widget, gpointer data);
extern void EditorSaveAsFileCB(GtkWidget *widget, gpointer data);
extern void EditorBackupCB(GtkWidget *widget, gpointer data);
extern void EditorBackupPreferencesCB(GtkWidget *widget, gpointer data);
extern void EditorExportFileCB(GtkWidget *widget, gpointer data);
extern void EditorImportFileCB(GtkWidget *widget, gpointer data);
extern void EditorRevertFileCB(GtkWidget *widget, gpointer data);
extern void EditorSyncMemoryCB(GtkWidget *widget, gpointer data);

extern void EditorUndoCB(GtkWidget *widget, gpointer data);
extern void EditorRedoCB(GtkWidget *widget, gpointer data);
extern void EditorCutCB(GtkWidget *widget, gpointer data);
extern void EditorCopyCB(GtkWidget *widget, gpointer data);
extern void EditorPasteCB(GtkWidget *widget, gpointer data);
extern void EditorMapClipboardCB(GtkWidget *widget, gpointer data);
extern void EditorWriteProtectEnableCB(GtkWidget *widget, gpointer data);
extern void EditorWriteProtectDisableCB(GtkWidget *widget, gpointer data);
extern void EditorMapClrSelCB(GtkWidget *widget, gpointer data);
extern void EditorMapTextureBrowserCB(GtkWidget *widget, gpointer data);

extern void EditorPreferencesCB(GtkWidget *widget, gpointer data);

extern void EditorPrimitiveVertexAddCB(GtkWidget *widget, gpointer data);
extern void EditorPrimitiveVertexRemoveCB(GtkWidget *widget, gpointer data);

extern void EditorScratchPadVertexInsertCB(GtkWidget *widget, gpointer data);
extern void EditorScratchPadVertexAppendCB(GtkWidget *widget, gpointer data);
extern void EditorScratchPadVertexEditCB(GtkWidget *widget, gpointer data);

extern void EditorPluginRenderCB(GtkWidget *widget, gpointer data);

extern void EditorButtonMenuMapCB(GtkButton *button, gpointer data);
extern void EditorMenuHideCB(GtkWidget *widget, gpointer data);

extern void EditorValueBrowseCB(GtkWidget *widget, gpointer data);
extern void EditorValueEnterCB(GtkWidget *widget, gpointer data);
extern void EditorValueApplyCB(GtkWidget *widget, gpointer data);

extern void EditorModelsListSelectCB(
	GtkWidget *widget, gint row, gint column,
	GdkEventButton *event, gpointer data
);
extern void EditorModelsListUnselectCB(
	GtkWidget *widget, gint row, gint column,
	GdkEventButton *event, gpointer data
);
extern void EditorPrimitivesListSelectCB(
	GtkWidget *widget,
	gint row,
	gint column,
	GdkEventButton *event,
	gpointer data
);
extern void EditorPrimitivesListUnselectCB(
	GtkWidget *widget,
	gint row,
	gint column,
	GdkEventButton *event,
	gpointer data
);
extern void EditorValuesListSelectCB(
	GtkWidget *widget, gint row, gint column,
	GdkEventButton *event, gpointer data
);
extern void EditorValuesListUnselectCB(
	GtkWidget *widget, gint row, gint column,
	GdkEventButton *event, gpointer data
);
extern void EditorListColumClickCB(
	GtkWidget *widget,
	gint column,
	gpointer data
);
extern gint EditorListMenuMapCB(
	GtkWidget *widget, gpointer event, gpointer data
);

extern void EditorToggleModelShowCB(GtkWidget *widget, gpointer data);




#endif	/* EDITORCB_H */
