/*
		    VMA Editor - Selecting and Matching

	Also handles selected primitives list IO.
 */

#ifndef EDITORSELECT_H
#define EDITORSELECT_H

#include <sys/types.h>

#include "view.h"
#include "editor.h"


extern void EditorSelect(gint **s, gint *t, gint n);
extern void EditorUnselect(gint **s, gint *t, gint n);
extern void EditorUnselectAll(gint **s, gint *t);
extern void EditorSelectSingle(gint **s, gint *t, gint n);
extern gint EditorGetSelected(gint *s, gint t, gint i);

extern gint EditorSelectPrimitiveRectangular(
	ma_editor_struct *editor,
	gint view_plane,		/* One of VMA_VIEW2D_TYPE_*. */
	gdouble vi0, gdouble vj0,
	gdouble vi1, gdouble vj1,
	gint start_pn,
	gint *vertex_num
);



#endif	/* EDITORSELECT_H */
