/*
		      Vertex Configuration Items List

	#included by vmacfg.h.

 */

#ifndef VMACFGLIST_H
#define VMACFGLIST_H


/*
 *	Configuration item parameter names:
 */
#define VMA_CFG_PARM_VERSION_MAJOR	"VersionMajor"
#define VMA_CFG_PARM_VERSION_MINOR	"VersionMinor"

#define VMA_CFG_PARM_DIR_LOCAL		"DirectoryLocal"
#define VMA_CFG_PARM_DIR_GLOBAL		"DirectoryGlobal"
#define VMA_CFG_PARM_DIR_PRESET_MODELS_LOCAL	"DirectoryPresetModelsLocal"
#define VMA_CFG_PARM_DIR_PRESET_MODELS_GLOBAL	"DirectoryPresetModelsGlobal"
#define VMA_CFG_PARM_DIR_PRESET_PRIMITIVES_LOCAL	"DirectoryPresetPrimitivesLocal"
#define VMA_CFG_PARM_DIR_PRESET_PRIMITIVES_GLOBAL	"DirectoryPresetPrimitivesGlobal"
#define VMA_CFG_PARM_DIR_PLUGINS_LOCAL	"DirectoryPluginsLocal"
#define VMA_CFG_PARM_DIR_PLUGINS_GLOBAL	"DirectoryPluginsGlobal"
#define VMA_CFG_PARM_DIR_TMP		"DirectoryTmp"

#define VMA_CFG_PARM_FILE_SCRATCHPAD	"FileScratchPad"
#define VMA_CFG_PARM_FILE_PLUGINS	"FilePlugins"

#define VMA_CFG_PARM_LAST_DIR_MODELS		"LastDirModels"
#define VMA_CFG_PARM_LAST_DIR_TEXTURES		"LastDirTextures"
#define VMA_CFG_PARM_LAST_DIR_VIEW_BACKGROUND_IMAGE	"LastDirViewBackgroundImage"
#define VMA_CFG_PARM_LAST_FILE_EXPORT		"LastFileExport"
#define VMA_CFG_PARM_LAST_EXT_EXPORT		"LastExtExport"

#define VMA_CFG_PARM_POINTER_EMULATE_2BUTTON	"PointerEmulate2Button"
#define VMA_CFG_PARM_UNDO_MAX			"UndoMax"

#define VMA_CFG_PARM_FONT_NAME_EDITABLE		"FontTextEditable"
#define VMA_CFG_PARM_FONT_NAME_TERMINAL		"FontTextTerminal"

#define VMA_CFG_PARM_VIEW_COLOR_BACKGROUND	"ViewColorBackground"
#define VMA_CFG_PARM_VIEW_COLOR_POINT		"ViewColorPoint"
#define VMA_CFG_PARM_VIEW_COLOR_LINE		"ViewColorLine"
#define VMA_CFG_PARM_VIEW_COLOR_LINE_STRIP	"ViewColorLineStrip"
#define VMA_CFG_PARM_VIEW_COLOR_LINE_LOOP	"ViewColorLineLoop"
#define VMA_CFG_PARM_VIEW_COLOR_TRIANGLE	"ViewColorTriangle"
#define VMA_CFG_PARM_VIEW_COLOR_TRIANGLE_STRIP	"ViewColorTriangleStrip"
#define VMA_CFG_PARM_VIEW_COLOR_TRIANGLE_FAN	"ViewColorTriangleFan"
#define VMA_CFG_PARM_VIEW_COLOR_QUAD		"ViewColorQuad"
#define VMA_CFG_PARM_VIEW_COLOR_QUAD_STRIP	"ViewColorQuadStrip"
#define VMA_CFG_PARM_VIEW_COLOR_POLYGON		"ViewColorPolygon"
#define VMA_CFG_PARM_VIEW_COLOR_TEXTURE_OUTLINE	"ViewColorTextureOutline"
#define VMA_CFG_PARM_VIEW_COLOR_TEXTURE_OUTLINE_SELECTED "ViewColorTextureOutlineSelected"
#define VMA_CFG_PARM_VIEW_COLOR_HEIGHTFIELD	"ViewColorHeightField"
#define VMA_CFG_PARM_VIEW_COLOR_GRID		"ViewColorGrid"
#define VMA_CFG_PARM_VIEW_COLOR_SELECTED	"ViewColorSelected"
#define VMA_CFG_PARM_VIEW_COLOR_SELECTED_VERTEX	"ViewColorSelectedVertex"
#define VMA_CFG_PARM_VIEW_COLOR_CURSORY		"ViewColorCursory"
#define VMA_CFG_PARM_VIEW_COLOR_NORMAL_VECTOR	"ViewColorNormalVector"

#define VMA_CFG_PARM_WIDTH			"Width"
#define VMA_CFG_PARM_HEIGHT			"Height"

#define VMA_CFG_PARM_TDIALOG_WIDTH		"TextDialogWidth"
#define VMA_CFG_PARM_TDIALOG_HEIGHT		"TextDialogHeight"
#define VMA_CFG_PARM_LIST_AND_VIEW_PANED_SIZE	"ListAndViewPanedSize"
#define VMA_CFG_PARM_PANEL0_SIZE		"Panel0Size"
#define VMA_CFG_PARM_PANEL1_SIZE		"Panel1Size"
#define VMA_CFG_PARM_PANEL2_SIZE		"Panel2Size"
#define VMA_CFG_PARM_PANEL_MODELS_LIST_SIZE	"PanelModelsListSize"
#define VMA_CFG_PARM_PANEL_VIEW_UPPER_SIZE	"PanelViewUpperSize"
#define VMA_CFG_PARM_PANEL_VIEW0_SIZE		"PanelView0Size"
#define VMA_CFG_PARM_PANEL_VIEW2_SIZE		"PanelView2Size"
#define VMA_CFG_PARM_PANEL_VALUES_LIST_SIZE	"PanelValuesListSize"
#define VMA_CFG_PARM_EDITOR_VALUES_CHWIDTH0	"ValuesListCHWidth0"
#define VMA_CFG_PARM_EDITOR_VALUES_CHWIDTH1	"ValuesListCHWidth1"
#define VMA_CFG_PARM_EDITOR_VALUES_CHWIDTH2	"ValuesListCHWidth2"

#define VMA_CFG_PARM_ROTATE_PRIMITIVE_ANGLE	"RotatePrimitiveAngle"
#define VMA_CFG_PARM_ROTATE_PRIMITIVE_ORBITAL_AXIS	"RotatePrimitiveOrbitalAxis"
#define VMA_CFG_PARM_ROTATE_PRIMITIVE_ROTATE_NORMALS	"RotatePrimitiveRotateNormals"

#define VMA_CFG_PARM_TRANSLATE_PRIMITIVE_X	"TranslatePrimitiveX"
#define VMA_CFG_PARM_TRANSLATE_PRIMITIVE_Y	"TranslatePrimitiveY"
#define VMA_CFG_PARM_TRANSLATE_PRIMITIVE_Z	"TranslatePrimitiveZ"

#define VMA_CFG_PARM_SCALE_PRIMITIVE_SCALE_TYPE	"ScalePrimitiveScaleType"
#define VMA_CFG_PARM_SCALE_PRIMITIVE_SCALE_COEFF	"ScalePrimitiveScaleCoeff"
#define VMA_CFG_PARM_SCALE_PRIMITIVE_SCALE_X	"ScalePrimitiveScaleX"
#define VMA_CFG_PARM_SCALE_PRIMITIVE_SCALE_Y	"ScalePrimitiveScaleY"
#define VMA_CFG_PARM_SCALE_PRIMITIVE_SCALE_Z	"ScalePrimitiveScaleZ"

#define VMA_CFG_PARM_MIRROR_PRIMITIVE_MIRROR_AXIS	"MirrorPrimitiveMirrorAxis"
#define VMA_CFG_PARM_MIRROR_PRIMITIVE_AXIS_OFFSET	"MirrorPrimitiveAxisOffset"
#define VMA_CFG_PARM_MIRROR_PRIMITIVE_MIRROR_NORMALS	"MirrorPrimitivesMirrorNormals"
#define VMA_CFG_PARM_MIRROR_PRIMITIVE_MIRROR_TEXCOORDS	"MirrorPrimitivesMirrorTexcoords"
#define VMA_CFG_PARM_MIRROR_PRIMITIVE_FLIP_WINDING	"MirrorPrimitivesFlipWinding"
#define VMA_CFG_PARM_MIRROR_PRIMITIVE_WIND_NORMALS	"MirrorPrimitivesWindNormals"
#define VMA_CFG_PARM_MIRROR_PRIMITIVE_WIND_TEXCOORDS	"MirrorPrimitivesWindTexcoords"

#define VMA_CFG_PARM_SNAP_PRIMITIVE_VERTICES	"SnapPrimitiveVertices"
#define VMA_CFG_PARM_SNAP_PRIMITIVE_NORMALS	"SnapPrimitiveNormals"
#define VMA_CFG_PARM_SNAP_PRIMITIVE_TEXCOORDS	"SnapPrimitiveTexcoords"
#define VMA_CFG_PARM_SNAP_PRIMITIVE_AXIS_X	"SnapPrimitiveAxisX"
#define VMA_CFG_PARM_SNAP_PRIMITIVE_AXIS_Y	"SnapPrimitiveAxisY"
#define VMA_CFG_PARM_SNAP_PRIMITIVE_AXIS_Z	"SnapPrimitiveAxisZ"
#define VMA_CFG_PARM_SNAP_PRIMITIVE_DIGITS	"SnapPrimitiveDigits"
#define VMA_CFG_PARM_SNAP_PRIMITIVE_RESOLUTION	"SnapPrimitiveResolution"

#define VMA_CFG_PARM_CLRSEL_UPDATE_PREVIEW	"ColorSelectorUpdatePreview"
#define VMA_CFG_PARM_CLRSEL_PREVIEW_QOBJ_TYPE	"ColorSelectorPreviewQObjType"
#define VMA_CFG_PARM_CLRSEL_LIGHT_ORBIT_POSITION	"ColorSelectorLightOrbitPosition"
#define VMA_CFG_PARM_CLRSEL_LIGHT_BRIGHTNESS	"ColorSelectorLightBrightness"

#define VMA_CFG_PARM_TEXBROWSER_WIDTH		"TextureBrowserWidth"
#define VMA_CFG_PARM_TEXBROWSER_HEIGHT		"TextureBrowserHeight"
#define VMA_CFG_PARM_TEXBROWSER_PREVIEW_WIDTH	"TextureBrowserPreviewWidth"
#define VMA_CFG_PARM_TEXBROWSER_PREVIEW_HEIGHT	"TextureBrowserPreviewHeight"
#define VMA_CFG_PARM_TEXBROWSER_INDEX_CHWIDTH	"TextureBrowserIndexCHWidth"
#define VMA_CFG_PARM_TEXBROWSER_NAME_CHWIDTH	"TextureBrowserNameCHWidth"
#define VMA_CFG_PARM_TEXBROWSER_PATH_CHWIDTH	"TextureBrowserPathCHWidth"
#define VMA_CFG_PARM_TEXBROWSER_PRIORITY_CHWIDTH	"TextureBrowserPriorityCHWidth"
#define VMA_CFG_PARM_TEXTURE_BASE_DIR		"TextureBaseDir"
#define VMA_CFG_PARM_TEXTURE_BASE_DIR_OVERRIDE	"TextureBaseDirOverride"

#define VMA_CFG_PARM_TOOLBAR_STYLE		"ToolBarStyle"
#define VMA_CFG_PARM_SHOW_TOOLTIPS		"ShowToolTips"
#define VMA_CFG_PARM_RECORD_LAST_POS_AND_SIZE	"RecordLastPositionsAndSize"
#define VMA_CFG_PARM_SHOW_TIPOFDAY		"ShowTipOfDay"

#define VMA_CFG_PARM_DATA_DECIMALS_POSITION	"DataDecimalsPosition"
#define VMA_CFG_PARM_DATA_DECIMALS_ANGLE	"DataDecimalsAngle"
#define VMA_CFG_PARM_VIEW_DECIMALS_POSITION	"ViewDecimalsPosition"
#define VMA_CFG_PARM_VIEW_DECIMALS_ANGLE	"ViewDecimalsAngle"
#define VMA_CFG_PARM_VIEW_RENDER		"ViewRender"
#define VMA_CFG_PARM_VIEW_CULL_FACES		"ViewCullFaces"
#define VMA_CFG_PARM_CULL_DIRECTION		"CullDirection"
#define VMA_CFG_PARM_VIEW_TRANSLATIONS_STATE	"ViewTranslationsState"
#define VMA_CFG_PARM_VIEW_CAM_CLIP_NEAR		"ViewCameraClipNear"
#define VMA_CFG_PARM_VIEW_CAM_CLIP_FAR		"ViewCameraClipFar"
#define VMA_CFG_PARM_VIEW_CAM_FOV		"ViewCameraFOV"
#define VMA_CFG_PARM_VIEW_ENABLE_ALPHA_CHANNEL	"ViewEnableAlphaChannel"

#define VMA_CFG_PARM_V3DFMT_PROMPT_ON_SAVE	"V3DFormatPromptOnSave"
#define VMA_CFG_PARM_V3DFMT_OPTIMIZATION	"V3DFormatOptimization"
#define VMA_CFG_PARM_V3DFMT_STRIP_EXTRAS	"V3DFormatStripComments"

#define VMA_CFG_PARM_BACKUP_ON_OPEN		"BackupOnOpen"
#define VMA_CFG_PARM_BACKUP_ON_SAVE		"BackupOnSave"
#define VMA_CFG_PARM_BACKUP_PERIODIC_INT	"BackupInt"
#define VMA_CFG_PARM_BACKUP_NEW_INDEX_HIGHEST	"BackupNewIndexHighest"
#define VMA_CFG_PARM_BACKUP_MAX			"BackupMax"

#define VMA_CFG_PARM_SCRATCHPAD_WIDTH		"ScratchPadWidth"
#define VMA_CFG_PARM_SCRATCHPAD_HEIGHT		"ScratchPadHeight"
#define VMA_CFG_PARM_SCRATCHPAD_CLIST_HEIGHT	"ScratchPadCListHeight"
#define VMA_CFG_PARM_SCRATCHPAD_CH0		"ScratchPadCH0"
#define VMA_CFG_PARM_SCRATCHPAD_CH1		"ScratchPadCH1"
#define VMA_CFG_PARM_SCRATCHPAD_CH2		"ScratchPadCH2"

#define VMA_CFG_PARM_PRINT_PRINT_TO		"PrintPrintTo"
#define VMA_CFG_PARM_PRINT_COMMAND		"PrintCommand"
#define VMA_CFG_PARM_PRINT_FILE			"PrintFile"
#define VMA_CFG_PARM_PRINT_VIEW			"PrintView"
#define VMA_CFG_PARM_PRINT_ORIENTATION		"PrintOrientation"
#define VMA_CFG_PARM_PRINT_VISUAL		"PrintVisual"
#define VMA_CFG_PARM_PRINT_PPI_X		"PrintPPIX"
#define VMA_CFG_PARM_PRINT_PPI_Y		"PrintPPIY"
#define VMA_CFG_PARM_PRINT_PAPER_SIZE		"PrintPaperSize"
#define VMA_CFG_PARM_PRINT_OUTPUT_OFFSET_X	"PrintOffsetX"
#define VMA_CFG_PARM_PRINT_OUTPUT_OFFSET_Y	"PrintOffsetY"
#define VMA_CFG_PARM_PRINT_OUTPUT_WIDTH		"PrintOutputWidth"
#define VMA_CFG_PARM_PRINT_OUTPUT_HEIGHT	"PrintOutputHeight"


/*
 *	Configuration items list:
 *
 *	Values are <type> <parm> <value_ptr>.
 *	See vmacfg.h for a list of valid values for <type>.
 *	See config.h for a list of valid values for <parm>.
 *	Initial value for <value_ptr> should always be NULL.
 *
 *	Be sure to update VMAInstallDefaultPreferences() in vmainstall.c
 *	to set default values when adding new parameters to this
 *	configuration options list.
 */
extern vma_cfg_item_struct option[];

#define VMA_OPTIONS_LIST_DECL	\
vma_cfg_item_struct option[] = { \
{ VMA_CFG_ITEM_TYPE_INT_32, VMA_CFG_PARM_VERSION_MAJOR, NULL }, \
{ VMA_CFG_ITEM_TYPE_INT_32, VMA_CFG_PARM_VERSION_MINOR, NULL }, \
\
{ VMA_CFG_ITEM_TYPE_STRING, VMA_CFG_PARM_DIR_GLOBAL, NULL }, \
{ VMA_CFG_ITEM_TYPE_STRING, VMA_CFG_PARM_DIR_LOCAL, NULL }, \
{ VMA_CFG_ITEM_TYPE_STRING, VMA_CFG_PARM_DIR_PRESET_MODELS_GLOBAL, NULL }, \
{ VMA_CFG_ITEM_TYPE_STRING, VMA_CFG_PARM_DIR_PRESET_MODELS_LOCAL, NULL }, \
{ VMA_CFG_ITEM_TYPE_STRING, VMA_CFG_PARM_DIR_PRESET_PRIMITIVES_GLOBAL, NULL }, \
{ VMA_CFG_ITEM_TYPE_STRING, VMA_CFG_PARM_DIR_PRESET_PRIMITIVES_LOCAL, NULL }, \
{ VMA_CFG_ITEM_TYPE_STRING, VMA_CFG_PARM_DIR_PLUGINS_GLOBAL, NULL }, \
{ VMA_CFG_ITEM_TYPE_STRING, VMA_CFG_PARM_DIR_PLUGINS_LOCAL, NULL }, \
{ VMA_CFG_ITEM_TYPE_STRING, VMA_CFG_PARM_DIR_TMP, NULL }, \
{ VMA_CFG_ITEM_TYPE_STRING, VMA_CFG_PARM_FILE_SCRATCHPAD, NULL }, \
{ VMA_CFG_ITEM_TYPE_STRING, VMA_CFG_PARM_FILE_PLUGINS, NULL }, \
\
{ VMA_CFG_ITEM_TYPE_STRING, VMA_CFG_PARM_LAST_DIR_MODELS, NULL }, \
{ VMA_CFG_ITEM_TYPE_STRING, VMA_CFG_PARM_LAST_DIR_TEXTURES, NULL }, \
{ VMA_CFG_ITEM_TYPE_STRING, VMA_CFG_PARM_LAST_DIR_VIEW_BACKGROUND_IMAGE, NULL }, \
\
{ VMA_CFG_ITEM_TYPE_STRING, VMA_CFG_PARM_LAST_FILE_EXPORT, NULL }, \
{ VMA_CFG_ITEM_TYPE_STRING, VMA_CFG_PARM_LAST_EXT_EXPORT, NULL }, \
\
{ VMA_CFG_ITEM_TYPE_U_INT_8, VMA_CFG_PARM_POINTER_EMULATE_2BUTTON, NULL }, \
\
{ VMA_CFG_ITEM_TYPE_U_INT_32, VMA_CFG_PARM_UNDO_MAX, NULL }, \
\
{ VMA_CFG_ITEM_TYPE_STRING, VMA_CFG_PARM_FONT_NAME_EDITABLE, NULL }, \
{ VMA_CFG_ITEM_TYPE_STRING, VMA_CFG_PARM_FONT_NAME_TERMINAL, NULL }, \
\
{ VMA_CFG_ITEM_TYPE_COLOR, VMA_CFG_PARM_VIEW_COLOR_BACKGROUND, NULL }, \
{ VMA_CFG_ITEM_TYPE_COLOR, VMA_CFG_PARM_VIEW_COLOR_POINT, NULL }, \
{ VMA_CFG_ITEM_TYPE_COLOR, VMA_CFG_PARM_VIEW_COLOR_LINE, NULL }, \
{ VMA_CFG_ITEM_TYPE_COLOR, VMA_CFG_PARM_VIEW_COLOR_LINE_STRIP, NULL }, \
{ VMA_CFG_ITEM_TYPE_COLOR, VMA_CFG_PARM_VIEW_COLOR_LINE_LOOP, NULL }, \
{ VMA_CFG_ITEM_TYPE_COLOR, VMA_CFG_PARM_VIEW_COLOR_TRIANGLE, NULL }, \
{ VMA_CFG_ITEM_TYPE_COLOR, VMA_CFG_PARM_VIEW_COLOR_TRIANGLE_STRIP, NULL }, \
{ VMA_CFG_ITEM_TYPE_COLOR, VMA_CFG_PARM_VIEW_COLOR_TRIANGLE_FAN, NULL }, \
{ VMA_CFG_ITEM_TYPE_COLOR, VMA_CFG_PARM_VIEW_COLOR_QUAD, NULL }, \
{ VMA_CFG_ITEM_TYPE_COLOR, VMA_CFG_PARM_VIEW_COLOR_QUAD_STRIP, NULL }, \
{ VMA_CFG_ITEM_TYPE_COLOR, VMA_CFG_PARM_VIEW_COLOR_POLYGON, NULL }, \
{ VMA_CFG_ITEM_TYPE_COLOR, VMA_CFG_PARM_VIEW_COLOR_TEXTURE_OUTLINE, NULL }, \
{ VMA_CFG_ITEM_TYPE_COLOR, VMA_CFG_PARM_VIEW_COLOR_TEXTURE_OUTLINE_SELECTED, NULL }, \
{ VMA_CFG_ITEM_TYPE_COLOR, VMA_CFG_PARM_VIEW_COLOR_HEIGHTFIELD, NULL}, \
{ VMA_CFG_ITEM_TYPE_COLOR, VMA_CFG_PARM_VIEW_COLOR_GRID, NULL }, \
{ VMA_CFG_ITEM_TYPE_COLOR, VMA_CFG_PARM_VIEW_COLOR_SELECTED, NULL }, \
{ VMA_CFG_ITEM_TYPE_COLOR, VMA_CFG_PARM_VIEW_COLOR_SELECTED_VERTEX, NULL }, \
{ VMA_CFG_ITEM_TYPE_COLOR, VMA_CFG_PARM_VIEW_COLOR_CURSORY, NULL }, \
{ VMA_CFG_ITEM_TYPE_COLOR, VMA_CFG_PARM_VIEW_COLOR_NORMAL_VECTOR, NULL }, \
\
{ VMA_CFG_ITEM_TYPE_U_INT_32, VMA_CFG_PARM_WIDTH, NULL }, \
{ VMA_CFG_ITEM_TYPE_U_INT_32, VMA_CFG_PARM_HEIGHT, NULL }, \
\
{ VMA_CFG_ITEM_TYPE_U_INT_32, VMA_CFG_PARM_TDIALOG_WIDTH, NULL }, \
{ VMA_CFG_ITEM_TYPE_U_INT_32, VMA_CFG_PARM_TDIALOG_HEIGHT, NULL }, \
{ VMA_CFG_ITEM_TYPE_U_INT_32, VMA_CFG_PARM_LIST_AND_VIEW_PANED_SIZE, NULL }, \
{ VMA_CFG_ITEM_TYPE_U_INT_32, VMA_CFG_PARM_PANEL0_SIZE, NULL }, \
{ VMA_CFG_ITEM_TYPE_U_INT_32, VMA_CFG_PARM_PANEL1_SIZE, NULL }, \
{ VMA_CFG_ITEM_TYPE_U_INT_32, VMA_CFG_PARM_PANEL2_SIZE, NULL }, \
{ VMA_CFG_ITEM_TYPE_U_INT_32, VMA_CFG_PARM_PANEL_MODELS_LIST_SIZE, NULL }, \
{ VMA_CFG_ITEM_TYPE_U_INT_32, VMA_CFG_PARM_PANEL_VIEW_UPPER_SIZE, NULL }, \
{ VMA_CFG_ITEM_TYPE_U_INT_32, VMA_CFG_PARM_PANEL_VIEW0_SIZE, NULL }, \
{ VMA_CFG_ITEM_TYPE_U_INT_32, VMA_CFG_PARM_PANEL_VIEW2_SIZE, NULL }, \
{ VMA_CFG_ITEM_TYPE_U_INT_32, VMA_CFG_PARM_PANEL_VALUES_LIST_SIZE, NULL }, \
{ VMA_CFG_ITEM_TYPE_U_INT_32, VMA_CFG_PARM_EDITOR_VALUES_CHWIDTH0, NULL }, \
{ VMA_CFG_ITEM_TYPE_U_INT_32, VMA_CFG_PARM_EDITOR_VALUES_CHWIDTH1, NULL }, \
{ VMA_CFG_ITEM_TYPE_U_INT_32, VMA_CFG_PARM_EDITOR_VALUES_CHWIDTH2, NULL }, \
\
{ VMA_CFG_ITEM_TYPE_DOUBLE, VMA_CFG_PARM_ROTATE_PRIMITIVE_ANGLE, NULL }, \
{ VMA_CFG_ITEM_TYPE_U_INT_32, VMA_CFG_PARM_ROTATE_PRIMITIVE_ORBITAL_AXIS, NULL }, \
{ VMA_CFG_ITEM_TYPE_U_INT_8, VMA_CFG_PARM_ROTATE_PRIMITIVE_ROTATE_NORMALS, NULL }, \
\
{ VMA_CFG_ITEM_TYPE_DOUBLE, VMA_CFG_PARM_TRANSLATE_PRIMITIVE_X, NULL }, \
{ VMA_CFG_ITEM_TYPE_DOUBLE, VMA_CFG_PARM_TRANSLATE_PRIMITIVE_Y, NULL }, \
{ VMA_CFG_ITEM_TYPE_DOUBLE, VMA_CFG_PARM_TRANSLATE_PRIMITIVE_Z, NULL }, \
\
{ VMA_CFG_ITEM_TYPE_U_INT_32, VMA_CFG_PARM_SCALE_PRIMITIVE_SCALE_TYPE, NULL }, \
{ VMA_CFG_ITEM_TYPE_DOUBLE, VMA_CFG_PARM_SCALE_PRIMITIVE_SCALE_COEFF, NULL }, \
{ VMA_CFG_ITEM_TYPE_DOUBLE, VMA_CFG_PARM_SCALE_PRIMITIVE_SCALE_X, NULL }, \
{ VMA_CFG_ITEM_TYPE_DOUBLE, VMA_CFG_PARM_SCALE_PRIMITIVE_SCALE_Y, NULL }, \
{ VMA_CFG_ITEM_TYPE_DOUBLE, VMA_CFG_PARM_SCALE_PRIMITIVE_SCALE_Z, NULL }, \
\
{ VMA_CFG_ITEM_TYPE_U_INT_32, VMA_CFG_PARM_MIRROR_PRIMITIVE_MIRROR_AXIS, NULL }, \
{ VMA_CFG_ITEM_TYPE_DOUBLE,  VMA_CFG_PARM_MIRROR_PRIMITIVE_AXIS_OFFSET, NULL }, \
{ VMA_CFG_ITEM_TYPE_U_INT_8, VMA_CFG_PARM_MIRROR_PRIMITIVE_MIRROR_NORMALS, NULL }, \
{ VMA_CFG_ITEM_TYPE_U_INT_8, VMA_CFG_PARM_MIRROR_PRIMITIVE_MIRROR_TEXCOORDS, NULL }, \
{ VMA_CFG_ITEM_TYPE_U_INT_8, VMA_CFG_PARM_MIRROR_PRIMITIVE_FLIP_WINDING, NULL }, \
{ VMA_CFG_ITEM_TYPE_U_INT_8, VMA_CFG_PARM_MIRROR_PRIMITIVE_WIND_NORMALS, NULL }, \
{ VMA_CFG_ITEM_TYPE_U_INT_8, VMA_CFG_PARM_MIRROR_PRIMITIVE_WIND_TEXCOORDS, NULL }, \
\
{ VMA_CFG_ITEM_TYPE_U_INT_8, VMA_CFG_PARM_SNAP_PRIMITIVE_VERTICES, NULL }, \
{ VMA_CFG_ITEM_TYPE_U_INT_8, VMA_CFG_PARM_SNAP_PRIMITIVE_NORMALS, NULL }, \
{ VMA_CFG_ITEM_TYPE_U_INT_8, VMA_CFG_PARM_SNAP_PRIMITIVE_TEXCOORDS, NULL }, \
{ VMA_CFG_ITEM_TYPE_U_INT_8, VMA_CFG_PARM_SNAP_PRIMITIVE_AXIS_X, NULL}, \
{ VMA_CFG_ITEM_TYPE_U_INT_8, VMA_CFG_PARM_SNAP_PRIMITIVE_AXIS_Y, NULL}, \
{ VMA_CFG_ITEM_TYPE_U_INT_8, VMA_CFG_PARM_SNAP_PRIMITIVE_AXIS_Z, NULL}, \
{ VMA_CFG_ITEM_TYPE_U_INT_8, VMA_CFG_PARM_SNAP_PRIMITIVE_DIGITS, NULL}, \
{ VMA_CFG_ITEM_TYPE_U_INT_32, VMA_CFG_PARM_SNAP_PRIMITIVE_RESOLUTION, NULL }, \
\
{ VMA_CFG_ITEM_TYPE_U_INT_32, VMA_CFG_PARM_TEXBROWSER_WIDTH, NULL }, \
{ VMA_CFG_ITEM_TYPE_U_INT_32, VMA_CFG_PARM_TEXBROWSER_HEIGHT, NULL }, \
{ VMA_CFG_ITEM_TYPE_U_INT_32, VMA_CFG_PARM_TEXBROWSER_PREVIEW_WIDTH, NULL }, \
{ VMA_CFG_ITEM_TYPE_U_INT_32, VMA_CFG_PARM_TEXBROWSER_PREVIEW_HEIGHT, NULL }, \
{ VMA_CFG_ITEM_TYPE_U_INT_32, VMA_CFG_PARM_TEXBROWSER_INDEX_CHWIDTH, NULL }, \
{ VMA_CFG_ITEM_TYPE_U_INT_32, VMA_CFG_PARM_TEXBROWSER_NAME_CHWIDTH, NULL }, \
{ VMA_CFG_ITEM_TYPE_U_INT_32, VMA_CFG_PARM_TEXBROWSER_PATH_CHWIDTH, NULL }, \
{ VMA_CFG_ITEM_TYPE_U_INT_32, VMA_CFG_PARM_TEXBROWSER_PRIORITY_CHWIDTH, NULL }, \
{ VMA_CFG_ITEM_TYPE_STRING, VMA_CFG_PARM_TEXTURE_BASE_DIR, NULL }, \
{ VMA_CFG_ITEM_TYPE_U_INT_8, VMA_CFG_PARM_TEXTURE_BASE_DIR_OVERRIDE, NULL }, \
\
{ VMA_CFG_ITEM_TYPE_U_INT_8, VMA_CFG_PARM_CLRSEL_UPDATE_PREVIEW, NULL }, \
{ VMA_CFG_ITEM_TYPE_U_INT_32, VMA_CFG_PARM_CLRSEL_PREVIEW_QOBJ_TYPE, NULL }, \
{ VMA_CFG_ITEM_TYPE_DOUBLE, VMA_CFG_PARM_CLRSEL_LIGHT_ORBIT_POSITION, NULL }, \
{ VMA_CFG_ITEM_TYPE_DOUBLE, VMA_CFG_PARM_CLRSEL_LIGHT_BRIGHTNESS, NULL }, \
\
{ VMA_CFG_ITEM_TYPE_U_INT_8, VMA_CFG_PARM_TOOLBAR_STYLE, NULL }, \
{ VMA_CFG_ITEM_TYPE_U_INT_8, VMA_CFG_PARM_SHOW_TOOLTIPS, NULL }, \
{ VMA_CFG_ITEM_TYPE_U_INT_8, VMA_CFG_PARM_RECORD_LAST_POS_AND_SIZE, NULL }, \
{ VMA_CFG_ITEM_TYPE_U_INT_8, VMA_CFG_PARM_SHOW_TIPOFDAY, NULL }, \
\
/* Resolution, vertex winding, and rendering. */ \
{ VMA_CFG_ITEM_TYPE_U_INT_32, VMA_CFG_PARM_DATA_DECIMALS_POSITION, NULL }, \
{ VMA_CFG_ITEM_TYPE_U_INT_32, VMA_CFG_PARM_DATA_DECIMALS_ANGLE, NULL }, \
{ VMA_CFG_ITEM_TYPE_U_INT_32, VMA_CFG_PARM_VIEW_DECIMALS_POSITION, NULL }, \
{ VMA_CFG_ITEM_TYPE_U_INT_32, VMA_CFG_PARM_VIEW_DECIMALS_ANGLE, NULL }, \
{ VMA_CFG_ITEM_TYPE_U_INT_8, VMA_CFG_PARM_VIEW_RENDER, NULL }, \
{ VMA_CFG_ITEM_TYPE_U_INT_8, VMA_CFG_PARM_VIEW_CULL_FACES, NULL }, \
{ VMA_CFG_ITEM_TYPE_U_INT_8, VMA_CFG_PARM_CULL_DIRECTION, NULL }, \
{ VMA_CFG_ITEM_TYPE_U_INT_8, VMA_CFG_PARM_VIEW_TRANSLATIONS_STATE, NULL }, \
{ VMA_CFG_ITEM_TYPE_U_INT_8, VMA_CFG_PARM_VIEW_ENABLE_ALPHA_CHANNEL, NULL }, \
{ VMA_CFG_ITEM_TYPE_DOUBLE, VMA_CFG_PARM_VIEW_CAM_CLIP_NEAR, NULL }, \
{ VMA_CFG_ITEM_TYPE_DOUBLE, VMA_CFG_PARM_VIEW_CAM_CLIP_FAR, NULL }, \
{ VMA_CFG_ITEM_TYPE_DOUBLE, VMA_CFG_PARM_VIEW_CAM_FOV, NULL }, \
\
{ VMA_CFG_ITEM_TYPE_U_INT_8, VMA_CFG_PARM_V3DFMT_PROMPT_ON_SAVE, NULL }, \
{ VMA_CFG_ITEM_TYPE_U_INT_32, VMA_CFG_PARM_V3DFMT_OPTIMIZATION, NULL }, \
{ VMA_CFG_ITEM_TYPE_U_INT_8, VMA_CFG_PARM_V3DFMT_STRIP_EXTRAS, NULL }, \
\
/* Backup. */ \
{ VMA_CFG_ITEM_TYPE_U_INT_8, VMA_CFG_PARM_BACKUP_ON_OPEN, NULL }, \
{ VMA_CFG_ITEM_TYPE_U_INT_8, VMA_CFG_PARM_BACKUP_ON_SAVE, NULL }, \
{ VMA_CFG_ITEM_TYPE_U_INT_32, VMA_CFG_PARM_BACKUP_PERIODIC_INT, NULL }, \
{ VMA_CFG_ITEM_TYPE_U_INT_8, VMA_CFG_PARM_BACKUP_NEW_INDEX_HIGHEST, NULL }, \
{ VMA_CFG_ITEM_TYPE_U_INT_32, VMA_CFG_PARM_BACKUP_MAX, NULL }, \
 \
/* ScratchPad. */ \
{ VMA_CFG_ITEM_TYPE_U_INT_32, VMA_CFG_PARM_SCRATCHPAD_WIDTH, NULL }, \
{ VMA_CFG_ITEM_TYPE_U_INT_32, VMA_CFG_PARM_SCRATCHPAD_HEIGHT, NULL }, \
{ VMA_CFG_ITEM_TYPE_U_INT_32, VMA_CFG_PARM_SCRATCHPAD_CLIST_HEIGHT, NULL }, \
{ VMA_CFG_ITEM_TYPE_U_INT_32, VMA_CFG_PARM_SCRATCHPAD_CH0, NULL }, \
{ VMA_CFG_ITEM_TYPE_U_INT_32, VMA_CFG_PARM_SCRATCHPAD_CH1, NULL }, \
{ VMA_CFG_ITEM_TYPE_U_INT_32, VMA_CFG_PARM_SCRATCHPAD_CH2, NULL }, \
 \
/* Print parameters. */ \
{ VMA_CFG_ITEM_TYPE_U_INT_32, VMA_CFG_PARM_PRINT_PRINT_TO, NULL }, \
{ VMA_CFG_ITEM_TYPE_STRING, VMA_CFG_PARM_PRINT_COMMAND, NULL }, \
{ VMA_CFG_ITEM_TYPE_STRING, VMA_CFG_PARM_PRINT_FILE, NULL }, \
{ VMA_CFG_ITEM_TYPE_U_INT_32, VMA_CFG_PARM_PRINT_VIEW, NULL }, \
{ VMA_CFG_ITEM_TYPE_U_INT_32, VMA_CFG_PARM_PRINT_ORIENTATION, NULL }, \
{ VMA_CFG_ITEM_TYPE_U_INT_32, VMA_CFG_PARM_PRINT_VISUAL, NULL }, \
{ VMA_CFG_ITEM_TYPE_DOUBLE, VMA_CFG_PARM_PRINT_PPI_X, NULL }, \
{ VMA_CFG_ITEM_TYPE_DOUBLE, VMA_CFG_PARM_PRINT_PPI_Y, NULL }, \
{ VMA_CFG_ITEM_TYPE_U_INT_32, VMA_CFG_PARM_PRINT_PAPER_SIZE, NULL }, \
{ VMA_CFG_ITEM_TYPE_INT_32, VMA_CFG_PARM_PRINT_OUTPUT_OFFSET_X, NULL }, \
{ VMA_CFG_ITEM_TYPE_INT_32, VMA_CFG_PARM_PRINT_OUTPUT_OFFSET_Y, NULL }, \
{ VMA_CFG_ITEM_TYPE_U_INT_32, VMA_CFG_PARM_PRINT_OUTPUT_WIDTH, NULL }, \
{ VMA_CFG_ITEM_TYPE_U_INT_32, VMA_CFG_PARM_PRINT_OUTPUT_HEIGHT, NULL }, \
 \
/* Last item must be all 0's. */ \
{ VMA_CFG_ITEM_TYPE_NONE, NULL, NULL } \
};

#endif	/* VMACFGLIST_H */
