/*
 *              Vertex Model Assembler: Status Bar
 */

#ifndef VMASTATUSBAR_H
#define VMASTATUSBAR_H

#include <sys/types.h>
#include <gtk/gtk.h>

#ifndef gbool
# define gbool	gboolean
#endif


/*
 *	Status bar structure:
 */
typedef struct {

	gbool initialized;
	gbool write_protect;		/* Last write protect state. */

	gpointer core_ptr;
	gpointer editor_ptr;

	GtkWidget *toplevel;		/* A GtkFrame. */
	GtkWidget *progress_bar;	/* A GtkProgressBar. */
	gdouble progress_pos_last;
	GtkWidget *label;		/* A GtkLabel. */
	GtkWidget *cursor_position;	/* A GtkLabel. */

	GtkWidget *buttons_handle;	/* Handle bar containing window 
					 * buttons.
					 */
	GtkWidget	*write_protect_enabled_eb,
			*write_protect_disabled_eb,
			*backup_enabled_eb,	/* Automatic backup. */
			*backup_disabled_eb,
			*new_editor_btn,
			*color_selector_btn,
			*light_properties_btn,
			*texture_browser_btn,
			*scratchpad_btn;

} vma_status_bar_struct;


extern vma_status_bar_struct *VMAStatusBarNew(
	void *core_ptr, void *editor_ptr, GtkWidget *parent
);
extern void VMAStatusBarUpdateMenus(vma_status_bar_struct *sb);
extern void VMAStatusBarDelete(vma_status_bar_struct *sb);

extern void VMAStatusBarCursorPosition(
	vma_status_bar_struct *sb, double x, double y, double z
);
extern void VMAStatusBarMessage(vma_status_bar_struct *sb, const char *mesg);
extern void VMAStatusBarProgress(vma_status_bar_struct *sb, double percent);




#endif	/* VMASTATUSBAR_H */
