#ifndef INCLUDED_VIEW3DS_DOCUMENT_H 
#define INCLUDED_VIEW3DS_DOCUMENT_H 
/*
 * The 3D Studio File Format Library
 * Copyright (C) 1996-2001 by J.E. Hoffmann <je-h@gmx.net>
 * All rights reserved.
 *
 * This program is  free  software;  you can redistribute it and/or modify it
 * under the terms of the  GNU Lesser General Public License  as published by 
 * the  Free Software Foundation;  either version 2.1 of the License,  or (at 
 * your option) any later version.
 *
 * This  program  is  distributed in  the  hope that it will  be useful,  but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or  FITNESS FOR A  PARTICULAR PURPOSE.  See the  GNU Lesser General Public  
 * License for more details.
 *
 * You should  have received  a copy of the GNU Lesser General Public License
 * along with  this program;  if not, write to the  Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: document.h,v 1.4 2001/01/15 10:56:12 jeh Exp $
 */

#ifndef INCLUDED_QOBJECT_H
#define INCLUDED_QOBJECT_H
#include <qobject.h>
#endif
#ifndef INCLUDED_LIB3DS_TYPES_H
#include <lib3ds/types.h>
#endif

/*!
 * Document class.
 */
class Document : public QObject {
  private:
    Q_OBJECT
    Lib3dsFile *d_file;
    QString d_camera;
    QTimer* d_timer;
  public:
    Document();
    virtual ~Document();

    bool open(QString filename);
    bool save(QString filename);

    Lib3dsFile* file();
    QString camera();

  signals:
    void documentChanged();

  public slots:
    void begin();
    void next();
    void play();
    void stop();
    void prev();
    void end();
    void setCurrent(int current);
    void setCamera(const QString& name);

  protected slots:
    void timerSlot();
};

#endif // INCLUDED_VIEW3DS_DOCUMENT_H 










