/*
 * Copyright (C) 2004  Stefan Kleine Stegemann
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef _H_OUTLINEPANEL
#define _H_OUTLINEPANEL

#include <Foundation/NSArray.h>
#include <Foundation/NSDictionary.h>
#include <AppKit/NSPanel.h>
#include <AppKit/NSScrollView.h>
#include <AppKit/NSOutlineView.h>
#include <PDFKit/PDFDocument.h>

/** This notification is posted if the user double-clicks
 *  on an outline item.   */
extern NSString* N_OutlineItemSelected;

/** Keys for user info dictionaries that come togehter
 *  with notifications posted by the OutlinePanel. */
extern NSString* UserInfoKeyOutlineItem;


/**
 * The OutlinePanel display's a document outline. There
 * is only one outline panel in the application that displays
 * the outline of the active document.
 *
 * To keep track of the outlines, the application must assign'
 * a unique name to each outline
 */
@interface OutlinePanel : NSPanel
{
   NSScrollView*         scrollView;
   NSOutlineView*        outlineView;
   NSView*               noOutlineView;
   NSString*             currentOutlineName;
   NSArray*              rootItems;
   NSMutableDictionary*  outlineStates;
   BOOL                  displaysOutline;
}

- (id) initWithContentRect: (NSRect)contentRect
                 styleMask: (unsigned int)styleMask
                   backing: (NSBackingStoreType)backingType
                     defer: (BOOL)flag;

- (void) showOutlineForDocument: (PDFDocument*)aDocument
                      usingName: (NSString*)aName;

- (void) outlineWillClose: (NSString*)anOutlineName;

- (NSOutlineView*) outlineView;

@end

#endif
