/* -*- C++ -*-
   
  This file is part of ViPEC
  Copyright (C) 1991-2000 Johan Rossouw (jrossouw@alcatel.altech.co.za)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef DRAWINGFRAME_H
#define DRAWINGFRAME_H

#include <qwidget.h>
#include <qframe.h>
#include <qpixmap.h>

class GraphView;

class DrawingFrame : public QFrame
{
  Q_OBJECT
public:
  DrawingFrame(GraphView& parent, const char *name=0);
  virtual ~DrawingFrame();

  void reDraw();

signals:
  void drawFrame( QPainter* p );
  void mouseMoved( QMouseEvent* );
  void mouseClicked( QMouseEvent* );

protected:
  virtual void mouseMoveEvent( QMouseEvent* );
  virtual void mousePressEvent( QMouseEvent* );
  virtual void drawContents ( QPainter* p );
  virtual void resizeEvent( QResizeEvent* );

  void clear();

protected:
  QPixmap buffer_;
  bool needsRedraw_;
private:
  GraphView& view_;
};

#endif
