/* -*- C++ -*-

  This file is part of ViPEC
  Copyright (C) 1991-2000 Johan Rossouw (jrossouw@alcatel.altech.co.za)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef SETUP_H
#define SETUP_H

#include <Types.h>
#include <DimensionDefinition.h>

#include <qmap.h>
#include <qstring.h>

typedef QMap<QString, DimensionDefinition> DimensionMap;

class Setup
{
public:
  static Setup* instance();
  ~Setup();
  
  DimensionMap&        getDimensionMap();
  DimensionDefinition* getDimensionDefinition( const QString& name,
					       bool translateKey = FALSE );
  TReal                getDimensionValue( const QString& name );

  bool solveByInversion();

  bool isLinearSweep() const;
  void setLinearSweep( bool );
  TReal getStartFrequency() const;
  void setStartFrequency( TReal );
  TReal getStopFrequency() const;
  void setStopFrequency( TReal );
  uint getNumberOfFrequencyPoints() const;
  void setNumberOfFrequencyPoints( uint );
  
  void buildFrequencyVector();
  Vector& getFrequencyVector();

  void setDebugMode( bool );
  bool isDebugMode() const;

  void setComponentTextEnabled( bool enabled );
  bool isComponentTextEnabled() const;

private:
  Setup();

  void initialize();

private:
  static Setup* instance_;
  DimensionMap dimensionMap_;
  
  //Sweep definition
  bool sweepLinear_;
  TReal sweepStartFrequency_;
  TReal sweepStopFrequency_;
  uint sweepNumberOfPoints_;
  Vector frequencies_;

  bool debugMode_;
  bool componentTextEnabled_;
};

#endif
