/* -*- C++ -*-

  This file is part of ViPEC
  Copyright (C) 1991-2000 Johan Rossouw (jrossouw@alcatel.altech.co.za)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <DataVector.h>

#include <stdio.h>
#include <iostream.h>

#ifndef _WS_WIN_
#include <stdlib.h>
#endif

//---------------------------------------------------------------------------
DataVector::DataVector()
{
  vectorSize_ = 0;
  pointer_ = 0;
  vector_ = NULL;
}

//---------------------------------------------------------------------------
DataVector::DataVector(uint size)
{
  vectorSize_ = size;

  vector_ = new TComplex [size];
  pointer_ = 0;

  zero();
}

//---------------------------------------------------------------------------
DataVector::~DataVector()
{
  delete[] vector_;
}

//---------------------------------------------------------------------------
DataVector& DataVector::operator= (const DataVector& vector)
{
  vectorSize_ = vector.vectorSize_;
  vector_ = new TComplex [vectorSize_];
  for (uint i = 0; i < vectorSize_; i++)
    {
      vector_[i] = vector.vector_[i];
    }
  return *this;
}

//---------------------------------------------------------------------------
TComplex& DataVector::operator()(uint pos)
{
  if (pos > vectorSize_)
    {
      cout << "Index out of bounds!";
      abort();
    }

  return vector_[pos];
}

//---------------------------------------------------------------------------
void DataVector::zero()
{
  if (vector_ == NULL)
    {
      return;
    }

  for (uint i = 0; i < vectorSize_; i++)
    {
      vector_[i] = TComplex(0,0);
    }
}

//---------------------------------------------------------------------------
void DataVector::addPoint(TComplex value)
{
  ASSERT( pointer_ < vectorSize_ );
  vector_[pointer_] = value;
  pointer_++;
}

//---------------------------------------------------------------------------
uint DataVector::getSize()
{
  return pointer_;
}
