/* -*- C++ -*-

  This file is part of ViPEC
  Copyright (C) 1991-2000 Johan Rossouw (jrossouw@alcatel.altech.co.za)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <Gyrator.h>

#include <Strings.h>
#include <TwoPorts.h>

#include "../images/gyrator.xpm"

QPixmap* Gyrator::pixmap_ = 0;

//-----------------------------------------------------------------
Gyrator::Gyrator( const QPoint& center )
  : Component( center )
{
}

//-----------------------------------------------------------------
Gyrator::~Gyrator()
{
}

//-----------------------------------------------------------------
const QString& Gyrator::getCatagory() const
{
  return Strings::LumpedCatagory;
}

//-----------------------------------------------------------------
const QString& Gyrator::getName() const
{
  return Strings::GyratorName;
}

//-----------------------------------------------------------------
const QPixmap& Gyrator::getPixmap() const
{
  if (!pixmap_)
    {
      pixmap_ = new QPixmap( gyrator_xpm );
    }
  return *pixmap_;
}

//-----------------------------------------------------------------
void Gyrator::initComponent()
{
  boundingRect_ = QRect(-24, -16, 48, 32);
  addNode( -24, -16 );
  addNode( -24, +16 );
  addNode( +24, -16 );
  addNode( +24, +16 );
  addAttribute( Strings::AttrGyratorFactor, "R" );
}

//-----------------------------------------------------------------
void Gyrator::drawSymbol(QPainter* p)
{
  p->moveTo( -24, -16 );
  p->lineTo( -18, -16 );
  p->lineTo( -18, +16 );
  p->lineTo( -24, +16 );
  p->moveTo( +24, -16 );
  p->lineTo( +18, -16 );
  p->lineTo( +18, +16 );
  p->lineTo( +24, +16 );
  p->drawArc( -24, -8, 16, 16, 16*270, 16*180 );
  p->drawArc( 10, -8, 16, 16, 16*90, 16*180 );
}

//-----------------------------------------------------------------
bool Gyrator::initSweep()
{
  bool changed = FALSE;
  TReal r = r_;
  
  r_ = getAttributeValue( "R" );
  
  if ( r != r_)
    {
      changed = TRUE;
    }
  return changed;
}

//-----------------------------------------------------------------
void Gyrator::addToAdmittanceMatrix( TReal, Matrix* yn )
{
  Matrix y;
  TwoPorts::getGYR( r_, y );
  uint nodes [4];
  for ( uint i=0; i<4; i++ )
    {
      nodes[i] = node(i)->getNodeNumber();
    }
  yn->insertTwoPort( y, nodes );
}
