#ifndef CLIN_H
#define CLIN_H

#include <Component.h>

#include <qpixmap.h>

class CLin : public Component
{
public:
  CLin( const QPoint& center );
  virtual ~CLin();

  virtual void initComponent();
  virtual void addToAdmittanceMatrix( TReal freq, Matrix* yn );

  virtual const QString& getCatagory() const;
  virtual const QString& getName() const;
  virtual const QPixmap& getPixmap() const;

  virtual bool initSweep();

protected:
  virtual void drawSymbol(QPainter*);

private:
  static QPixmap* pixmap_;
  TReal ze_;
  TReal zo_;
  TReal e_;
  TReal f_;
};

#endif
