/* -*- C++ -*-

  This file is part of ViPEC
  Copyright (C) 1991-2001 Johan Rossouw (jrossouw@alcatel.altech.co.za)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef TUNERWINDOW_H
#define TUNERWINDOW_H

#include <qmap.h>
#include <qlist.h>
#include <qlabel.h>
#include <qarray.h>
#include <qdialog.h>
#include <qstring.h>

class QCheckBox;
class QVBoxLayout;
class QGridLayout;
class RealSlider;

class TunerWindow : public QDialog
{
  Q_OBJECT;
public:

  TunerWindow( QWidget* parent, const char * name=0 );
  virtual ~TunerWindow();
  
  void setRangeList( QList<QString> nameList,
		     QList<QString> rangeList );
 
private slots:
  void sweepSlot();
  void closeSlot();
  void updateLabels( int );
  void sliderReleased();

private:
  void destroyWidgets();

private:
  QVBoxLayout* topLayout_;
  QGridLayout* gridLayout_;
  QCheckBox*   updateCheckbox_;

  QList<QLabel> labelList_;
  QList<QLabel> valueList_;
  QMap< QString, RealSlider* > rangeControlMap_;

};

#endif

