(**
  A layout group, that layouts a number of buttons horizontaly.
**)

MODULE VOButtonRow;

(*
    A layout group, that layouts a number of buttons horizontaly.
    Copyright (C) 1997  Tim Teulings (rael@edge.ping.de)

    This module is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.

    This module is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with VisualOberon. If not, write to the Free Software Foundation,
    59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

IMPORT D := VODisplay,
       G := VOGUIObject;

TYPE
  Prefs*     = POINTER TO PrefsDesc;

  (**
    In this class all preferences stuff of the button row is stored.
  **)

  PrefsDesc* = RECORD (G.PrefsDesc)
                 alignment*  : LONGINT;
               END;

  ButtonRow*     = POINTER TO ButtonRowDesc;
  ButtonRowDesc* = RECORD(G.GroupDesc)
                     prefs       : Prefs;
                     buttonWidth : LONGINT;
                   END;

VAR
  prefs* : Prefs;

  PROCEDURE (p : Prefs) Init*;

  BEGIN
    p.Init^;

    p.alignment:=G.alignRight;
  END Init;

  PROCEDURE (p : Prefs) SetPrefs(b : ButtonRow);

  BEGIN
    b.prefs:=p;   (* We set the prefs *)

    IF p.background#NIL THEN
      b.SetBackgroundObject(p.background.Copy());
      b.backgroundObject.source:=b;
    END;
  END SetPrefs;

  PROCEDURE (b : ButtonRow) Init*;

  BEGIN
    b.Init^;

    prefs.SetPrefs(b);
  END Init;

  PROCEDURE (b : ButtonRow) CalcSize*(display : D.Display);

  VAR
    object  : G.Object;

  BEGIN
    b.width:=0;
    b.height:=0;

    object:=b.list;
    WHILE object#NIL DO
      object.CalcSize(display);
      b.height:=G.MaxLong(b.height,object.oHeight);
      b.buttonWidth:=G.MaxLong(b.buttonWidth,object.oWidth);

      object:=object.next;
    END;

    b.width:=b.count*b.buttonWidth+(b.count-1)*display.spaceWidth;
    b.minWidth:=b.width;
    b.minHeight:=b.height;

    b.CalcSize^(display);
  END CalcSize;

  PROCEDURE (b : ButtonRow) Draw*(x,y : LONGINT; draw : D.DrawInfo);

  VAR
    object : G.Object;
    pos,
    count  : LONGINT;

  BEGIN
    b.Draw^(x,y,draw);

    b.DrawBackground(b.x,b.y,b.width,b.height);

    CASE b.prefs.alignment OF
      G.alignLeft:
        pos:=b.x;
        object:=b.list;
        WHILE object#NIL DO
          object.Resize(b.buttonWidth,b.height);
          object.Draw(pos,b.y + (b.height-object.oHeight) DIV 2,draw);
          INC(pos,object.width+b.display.spaceWidth);

          object:=object.next;
        END;
    | G.alignRight:
        pos:=b.x+b.width-b.count*b.buttonWidth-(b.count-1)*b.display.spaceWidth;
        object:=b.list;
        WHILE object#NIL DO
          object.Resize(b.buttonWidth,b.height);
          object.Draw(pos,b.y + (b.height-object.oHeight) DIV 2,draw);
          INC(pos,object.width+b.display.spaceWidth);

          object:=object.next;
        END;
    | G.alignCenter:
        pos:=b.x+(b.width-b.count*b.buttonWidth-(b.count-1)*b.display.spaceWidth) DIV 2;
        object:=b.list;
        WHILE object#NIL DO
          object.Resize(b.buttonWidth,b.height);
          object.Draw(pos,b.y + (b.height-object.oHeight) DIV 2,draw);
          INC(pos,object.width+b.display.spaceWidth);

          object:=object.next;
        END;
    | G.alignBound:
        pos:=b.x;
        count:=1;
        object:=b.list;
        WHILE object#NIL DO
          object.Resize(b.buttonWidth,b.height);
          object.Draw(pos,b.y + (b.height-object.oHeight) DIV 2,draw);

          IF count<b.count THEN
            INC(pos,object.width);
            INC(pos,(b.width-(pos-b.x)-(b.count-count)*b.buttonWidth)  DIV (b.count-count));
          END;

          INC(count);
          object:=object.next;
        END;
    END;
  END Draw;

  PROCEDURE (a : ButtonRow) Hide*;

  VAR
    help : G.Object;

  BEGIN
    IF a.visible THEN
      help:=a.list;
      WHILE help#NIL DO
        help.Hide;
        help:=help.next;
      END;
    END;
    a.Hide^;
  END Hide;

BEGIN
  NEW(prefs);
  prefs.Init;
END VOButtonRow.