MODULE VOCyclePrefs;

(*
    Copyright (C) 1999  Tim Teulings (rael@edge.ping.de)

    This module is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.

    This module is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with VisualOberon. If not, write to the Free Software Foundation,
    59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

IMPORT B   := VOButton,
       BG  := VOBackground,
       BO  := VOBool,
       C   := VOCycle,
       F   := VOFrame,
       FG  := VOFrameGroup,
       FSD := VOFrmSelDlg,
       G   := VOGUIObject,
       ISD := VOImgSelDlg,
       L   := VOLabel,
       O   := VOObject,
       P   := VOPanel,
       PG  := VOPrefsGUI,
       PP  := VOPrefsParser,
       S   := VOSpace,
       V   := VOVecImage,
       VM  := VOValue;

TYPE
  Item*     = POINTER TO ItemDesc;
  ItemDesc* = RECORD (PG.PrefsItemDesc)
                prefs      : C.PrefsDesc;
                frmSelDlg  : FSD.FrmSelDlg;
                frame      : F.Frame;
                imgSelDlg  : ISD.ImgSelDlg;
                image      : V.VecImage;
                imageRight : VM.BoolModel;
                highlight  : VM.BoolModel;
              END;

VAR
  prefs : Item;

  PROCEDURE (d : Item) Init*;

  BEGIN
    d.Init^;
    d.name:="Cycle";
    PG.settings.AddItem(d);

    NEW(d.frmSelDlg);
    d.frmSelDlg.Init;
    NEW(d.imgSelDlg);
    d.imgSelDlg.Init;
  END Init;

  PROCEDURE (d : Item) GetObject*():G.Object;

  VAR
    bool     : BO.Bool;
    button   : B.Button;
    frame    :FG.FrameGroup;
    label    : L.Label;
    panel    : P.Panel;
    space    : S.Space;

  BEGIN
    d.frmSelDlg.SetDisplay(d.display);
    d.imgSelDlg.SetDisplay(d.display);

    d.frmSelDlg.Forward(FSD.setMsg,d);
    d.imgSelDlg.Forward(ISD.setMsg,d);

    NEW(panel);
    panel.Init;
    panel.Set(P.vertical);

      NEW(frame);
      frame.Init;
      frame.SetFlags({G.horizontalFlex});
      frame.SetTextLabel("Frame");

        button:=PG.CreateFrameButton(d.prefs.frame,d.frame,d.display,d.frmSelDlg,
                                     d.window.keyHandler,"Select frame");
      frame.Add(button);
    panel.Add(frame);

      NEW(space);
      space.Init;
      space.Set(TRUE,S.normal);
    panel.Add(space);

      NEW(frame);
      frame.Init;
      frame.SetFlags({G.horizontalFlex});
      frame.SetTextLabel("Image");

       button:=PG.CreateImageButton(d.prefs.image,d.image,d.display,d.imgSelDlg,
                                     d.window.keyHandler,"Select image");
      frame.Add(button);
    panel.Add(frame);

      NEW(space);
      space.Init;
      space.Set(TRUE,S.normal);
    panel.Add(space);

      NEW(frame);
      frame.Init;
      frame.SetFlags({G.horizontalFlex});
      frame.SetTextLabel("Options");

        NEW(label);
        label.Init;

          NEW(d.imageRight);
          d.imageRight.Init;
          d.imageRight.SetBoolean(d.prefs.imageRight);

          NEW(bool);
          bool.Init;
          bool.SetModel(d.imageRight);
          d.window.keyHandler.AddFocusObject(bool);
          bool.Forward(BO.clickedMsg,d);
        label.AddTextLabel("Image on right side",bool);

          NEW(d.highlight);
          d.highlight.Init;
          d.highlight.SetBoolean(d.prefs.highlight);

          NEW(bool);
          bool.Init;
          bool.SetModel(d.highlight);
          d.window.keyHandler.AddFocusObject(bool);
          bool.Forward(BO.clickedMsg,d);
        label.AddTextLabel("Highlight label",bool);
      frame.Add(label);
    panel.Add(frame);

    RETURN panel;
  END GetObject;

  PROCEDURE (p : Item) Refresh*;

  BEGIN
    p.prefs:=C.prefs^;

    p.frmSelDlg.SetFrame(p.prefs.frame);
    p.frame.SetInternalFrame(p.prefs.frame);
    p.imgSelDlg.SetImage(p.prefs.image);
    p.image.Set(p.prefs.image);
    p.imageRight.SetBoolean(p.prefs.imageRight);
    p.highlight.SetBoolean(p.prefs.highlight);
 END Refresh;

  PROCEDURE (p : Item) LoadPrefs*(appName : ARRAY OF CHAR);

  VAR
    buffer : ARRAY 256 OF CHAR;
    pos    : LONGINT;
    top    : PP.Item;


  BEGIN
    p.LoadPrefs^(appName);

    top:=p.LoadPrefsFile("Cycle",appName);
    IF top=NIL THEN
      RETURN;
    END;
    top:=top.GetEntry("CYCLE");
    IF top=NIL THEN
      RETURN;
    END;

    IF top.GetStringEntry("frame",buffer) THEN
      pos:=F.GetFrameEntry(buffer);
      IF pos>=0 THEN
        C.prefs.frame:=pos;
      ELSE
        p.ErrorWrongData("CYCLE/frame",buffer);
      END;
    END;

    IF top.GetStringEntry("image",buffer) THEN
      pos:=V.GetImageEntry(buffer);
      IF pos>=0 THEN
        C.prefs.image:=pos;
      ELSE
        p.ErrorWrongData("CYCLE/image",buffer);
      END;
    END;

    C.prefs.imageRight:=top.GetBoolEntry("imageRight",C.prefs.imageRight);
    C.prefs.highlight:=top.GetBoolEntry("highlight",C.prefs.highlight);

    C.prefs.background:=BG.LoadBackground(top);
  END LoadPrefs;

  PROCEDURE (p : Item) Apply*;

  BEGIN
    C.prefs^:=p.prefs;
  END Apply;

  PROCEDURE (p : Item) Save*;

  VAR
    block    : PP.BlockItem;
    value    : PP.ValueItem;

  BEGIN
    NEW(block);
    block.Init;
    block.SetName("CYCLE");
      NEW(value);
      value.Init;
      value.SetValue("frame",F.internalFrames[p.prefs.frame]);
    block.AddItem(value);
      NEW(value);
      value.Init;
      value.SetValue("image",V.images[p.prefs.image]);
    block.AddItem(value);
      NEW(value);
      value.Init;
      value.SetBool("imageRight",p.prefs.imageRight);
    block.AddItem(value);
      NEW(value);
      value.Init;
      value.SetBool("highlight",p.prefs.highlight);
    block.AddItem(value);

    BG.SaveBackground(block,p.prefs.background);

    p.SaveItems("Cycle",block);
  END Save;

  PROCEDURE (p : Item) Receive*(message : O.Message);

  BEGIN
    WITH
      message : FSD.SetMsg DO
        p.frame.SetInternalFrame(message.frame);
        p.prefs.frame:=message.frame;
    | message : ISD.SetMsg DO
        p.image.Set(message.image);
        p.prefs.image:=message.image;
    | message : BO.ClickedMsg DO
        p.prefs.imageRight:=p.imageRight.GetBoolean();
        p.prefs.highlight:=p.highlight.GetBoolean();
     ELSE
      p.Receive^(message);
    END;
  END Receive;

BEGIN
  NEW(prefs);
  prefs.Init;

END VOCyclePrefs.