MODULE VOTextPrefs;

(*
    Copyright (C) 1999  Tim Teulings (rael@edge.ping.de)

    This module is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.

    This module is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with VisualOberon. If not, write to the Free Software Foundation,
    59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

IMPORT B   := VOButton,
       BG  := VOBackground,
       BO  := VOBool,
       F   := VOFrame,
       FG  := VOFrameGroup,
       FSD := VOFrmSelDlg,
       G   := VOGUIObject,
       L   := VOLabel,
       O   := VOObject,
       P   := VOPanel,
       PG  := VOPrefsGUI,
       PP  := VOPrefsParser,
       SP  := VOSpace,
       T   := VOText,
       V   := VOValue;

TYPE
  Item*     = POINTER TO ItemDesc;
  ItemDesc* = RECORD (PG.PrefsItemDesc)
                prefs      : T.PrefsDesc;
                frmSelDlg  : FSD.FrmSelDlg;
                highlight  : V.BoolModel;
                frame      : F.Frame;
              END;

VAR
  prefs : Item;

  PROCEDURE (d : Item) Init*;

  BEGIN
    d.Init^;
    d.name:="Text";
    PG.settings.AddItem(d);

    NEW(d.frmSelDlg);
    d.frmSelDlg.Init;
  END Init;

  PROCEDURE (d : Item) Refresh*;

  BEGIN
    d.prefs:=T.prefs^;

    d.frame.SetInternalFrame(d.prefs.frame);
    d.frmSelDlg.SetFrame(d.prefs.frame);
    d.highlight.SetBoolean(d.prefs.highlight);
  END Refresh;

  PROCEDURE (d : Item) GetObject*():G.Object;

  VAR
    bool   : BO.Bool;
    button : B.Button;
    frame  : FG.FrameGroup;
    label  : L.Label;
    panel  : P.Panel;
    space  : SP.Space;

  BEGIN
    d.frmSelDlg.SetDisplay(d.display);
    d.frmSelDlg.Forward(FSD.setMsg,d);

    NEW(panel);
    panel.Init;
    panel.Set(P.vertical);

      NEW(frame);
      frame.Init;
      frame.SetFlags({G.horizontalFlex});
      frame.SetTextLabel("Focus frame");

        button:=PG.CreateFrameButton(d.prefs.frame,d.frame,d.display,d.frmSelDlg,
                                     d.window.keyHandler,"Select frame");
      frame.Add(button);
    panel.Add(frame);

      NEW(space);
      space.Init;
      space.Set(TRUE,SP.normal);
    panel.Add(space);

      NEW(frame);
      frame.Init;
      frame.SetFlags({G.horizontalFlex});
      frame.SetTextLabel("Options");

        NEW(label);
        label.Init;

          NEW(d.highlight);
          d.highlight.Init;
          d.highlight.SetBoolean(d.prefs.highlight);

          NEW(bool);
          bool.Init;
          bool.SetModel(d.highlight);
          d.window.keyHandler.AddFocusObject(bool);
          bool.Forward(BO.clickedMsg,d);
        label.AddTextLabel("Highlight",bool);
      frame.Add(label);
    panel.Add(frame);

    RETURN panel;
  END GetObject;

  PROCEDURE (p : Item) LoadPrefs*(appName : ARRAY OF CHAR);

  VAR
    buffer   : ARRAY 256 OF CHAR;
    pos      : LONGINT;
    top      : PP.Item;


  BEGIN
    p.LoadPrefs^(appName);

    top:=p.LoadPrefsFile("Text",appName);
    IF top=NIL THEN
      RETURN;
    END;
    top:=top.GetEntry("TEXT");
    IF top=NIL THEN
      RETURN;
    END;

    IF top.GetStringEntry("focus",buffer) THEN
      pos:=F.GetFrameEntry(buffer);
      IF pos>=0 THEN
        T.prefs.frame:=pos;
      ELSE
        p.ErrorWrongData("TEXT/focus",buffer);
      END;
    END;
    T.prefs.highlight:=top.GetBoolEntry("highlight",T.prefs.highlight);

    T.prefs.background:=BG.LoadBackground(top);
  END LoadPrefs;

  PROCEDURE (p : Item) Apply*;

  BEGIN
    T.prefs^:=p.prefs;
  END Apply;

  PROCEDURE (p : Item) Save*;

  VAR
    block    : PP.BlockItem;
    value    : PP.ValueItem;

  BEGIN
    NEW(block);
    block.Init;
    block.SetName("TEXT");
      NEW(value);
      value.Init;
      value.SetValue("focus",F.internalFrames[p.prefs.frame]);
    block.AddItem(value);

      NEW(value);
      value.Init;
      value.SetBool("highlight",p.prefs.highlight);
    block.AddItem(value);

    BG.SaveBackground(block,p.prefs.background);

    p.SaveItems("Text",block);
  END Save;

  PROCEDURE (p : Item) Receive*(message : O.Message);

  BEGIN
    WITH
      message : FSD.SetMsg DO
        p.frame.SetInternalFrame(message.frame);
        p.prefs.frame:=message.frame;
    | message : BO.ClickedMsg DO
        p.prefs.highlight:=p.highlight.GetBoolean();
    ELSE
      p.Receive^(message);
    END;
  END Receive;

BEGIN
  NEW(prefs);
  prefs.Init;

END VOTextPrefs.