/*********************************************************************
 *
 * Authors: Vincenzo Ciaschini - Vincenzo.Ciaschini@cnaf.infn.it 
 *
 * Copyright (c) Members of the EGEE Collaboration. 2004-2010.
 * See http://www.eu-egee.org/partners/ for details on the copyright holders.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Parts of this code may be based upon or even include verbatim pieces,
 * originally written by other people, in which case the original header
 * follows.
 *
 *********************************************************************/
#ifndef VOMS_NEWCA_H
#define VMS_NEWCA_H

extern "C" {
#include <openssl/x509.h>
#include <openssl/evp.h>

/* newca.c */
extern char *get_peer_CA(gss_ctx_id_t context, int globusver);
extern char *getMCA(void *credential, int version);
extern EVP_PKEY *get_private_key(void *credential, int globusver);
extern EVP_PKEY *get_delegated_public_key(gss_ctx_id_t context, int globusver);
extern X509 *get_peer_cert(gss_ctx_id_t contex, int globusver);
extern int   get_peer_data(gss_ctx_id_t, int, EVP_PKEY **, char **, X509 **);
extern int   get_own_data(gss_ctx_id_t, int, EVP_PKEY **, char **, X509 **);
};

#endif
