// This may look like C code, but it is really -*- C++ -*-
// 
// <copyright> 
//  
//  Copyright (c) 1995
//  Institute for Information Processing and Computer Supported New Media (IICM), 
//  Graz University of Technology, Austria. 
//  
// </copyright> 
// 
// 
// <file> 
// 
// Name:        tio.h
// 
// Purpose:     
// 
// Created:     11 Mar 96   Joerg Faschingbauer
// 
// Modified:    
// 
// Description: 
// 
// $Id: tio.h,v 1.6 1997/02/21 16:11:33 jfasch Exp $
// 
// $Log: tio.h,v $
// Revision 1.6  1997/02/21 16:11:33  jfasch
// *** empty log message ***
//
// Revision 1.5  1997/02/21 16:09:05  jfasch
// version2
//
// Revision 1.4  1997/02/21 16:08:19  jfasch
// egoist()
//
// Revision 1.3  1997/02/12 23:13:11  jfasch
// moved from HgDcCommon
//
// Revision 1.2  1996/03/28 09:51:54  jfasch
// decoupling things from Dispatcher
//
// Revision 1.1  1996/03/22 16:23:11  jfasch
// Initial revision
//
// 
// </file> 
#ifndef hg_dispatch_tio_h
#define hg_dispatch_tio_h

#include <hyperg/utils/smartptr.h>

class TransparentIOHandler ;

class TransparentIO : public RefCounted {
public:
   virtual ~TransparentIO() {}

   virtual void registerOutput (TransparentIOHandler*) = 0 ;
   virtual void registerInput (TransparentIOHandler*) = 0 ;

   virtual int read (char*, int) = 0 ;
   virtual int write (const char*, int) = 0 ;

   const TransparentIOHandler* reader() const { return reader_ ; }
   const TransparentIOHandler* writer() const { return writer_ ; }

   // this is quite a hack. Harmony needs it to be able to receive
   // events on just one file number. use is discouraged. just for
   // backward compatibility. shit.
   virtual void egoist (bool) = 0 ;

protected:
   TransparentIO() : reader_(nil), writer_(nil) {}

   void set_reader_(TransparentIOHandler* h) { reader_=h; }
   void set_writer_(TransparentIOHandler* h) { writer_=h; }
   TransparentIOHandler* get_reader_() const { return reader_; }
   TransparentIOHandler* get_writer_() const { return writer_; }

private:
   TransparentIOHandler* reader_ ;
   TransparentIOHandler* writer_ ;

public:
   static const char* version2 ;
} ;
static const char* dc_common_common_tio_version = TransparentIO::version2 ;

class TransparentIOHandler {
public:
   virtual void inputReady (const TransparentIO*) = 0 ;
   virtual void outputReady (const TransparentIO*) = 0 ;
} ;

SmartPtrdeclare (TransparentIOPtr, TransparentIO) ;

#endif
