// This may look like C code, but it is really -*- C++ -*-
// 
// <copyright> 
//  
//  Copyright (c) 1996
//  Institute for Information Processing and Computer Supported New Media (IICM), 
//  Graz University of Technology, Austria. 
//  
// </copyright> 
// 
// 
// <file> 
// 
// Name:        condition.h
// 
// Purpose:     
// 
// Created:     19 Nov 1996   Joerg Faschingbauer
// 
// Modified:    
// 
// Description: 
// 
// $Id: condition.C,v 1.2 1996/12/06 16:35:01 jfasch Exp $
// 
// $Log: condition.C,v $
// Revision 1.2  1996/12/06 16:35:01  jfasch
// mutex is a pointer instead of a reference
//
// Revision 1.1  1996/12/06 13:36:58  root
// Initial revision
//
// 
// </file> 
#include "condition.h"

#include "assert.h"

// --------------------------------------------------------------------
Verbose HWCondition :: verbose ;
const char* HWCondition :: version1 = "HWCondition: $Id: condition.C,v 1.2 1996/12/06 16:35:01 jfasch Exp $" ;

HWCondition :: HWCondition (HWMutexLock& lock)
: lock_(&lock) {
#ifdef Solaris
   error_ = ::cond_init (&cond_, USYNC_THREAD, 0 /*ignored with USYNC_THREAD*/) ;
   if (error_) {
      DEBUGNL ("HWCondition::HWCondition(): ::cond_init() failed, error was: "<<error_) ;
   }
#else
   hgassert (false, "HWCondition::HWCondition(): mutexes are not supported on this system") ;
   error_ = 1 ;
#endif
}

HWCondition :: ~HWCondition() {
   if (! error_) {
#ifdef Solaris
      error_ = :: cond_destroy (&cond_) ;
#endif
   }
   if (error_) {
#ifdef Solaris
         DEBUGNL ("HWCondition::~HWCondition(): ::cond_destroy() failed, error was: "<<error_) ;
#endif
   }
}

void HWCondition :: wait() {
#ifdef Solaris
   error_ = ::cond_wait (&cond_, &(lock_->mutex_)) ;
   if (error_) {
      DEBUGNL ("HWCondition::wait(): ::cond_wait() failed, error was: "<<error_) ;
   }
#endif
}

void HWCondition :: signal() {
#ifdef Solaris
   error_ = ::cond_signal (&cond_) ;
   if (error_) {
      DEBUGNL ("HWCondition::signal(): ::cond_signal() failed, error was: "<<error_) ;
   }
#endif
}
