// This may look like C code, but it is really -*- C++ -*-

//<copyright>
//
// Copyright (c) 1993-1996
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
//
//</copyright>

//<file>
//
// Name: bubblewindow.h
//
// Purpose: creates a popup window with bubble style and shading around the bubble
//
// Created: 5 Sept 95 Peter Kogler
//
// $Id: bubblewindow.h,v 1.8 1996/10/22 10:37:40 jschipf Exp $
//
// Description:
//
// BubbleWindow creates a popup window, which ist not under the control of the window
// manager, and the background is transparent.
// BubbleWindow shows its contained glyph in a bubble, which may be round or squary
// and can show in every direction (up ,down, left, right). The bubble has a shadowed
// outline, the frame of the bubble and the inner background of the bubble can be
// colored in any appropriate color. The size of the frame of the bubble can be set.
// In this implementation BubbleWindow pops up near the mouse coordinates in the right
// direction.
//
//</file>
//
// $Log: bubblewindow.h,v $
// Revision 1.8  1996/10/22 10:37:40  jschipf
// chaged the prototye of background, and foreground
//
// Revision 1.7  1996/02/21 14:32:32  bmarsch
// Further beautified default bubble window
//

#ifndef harmony_widgets_bubblewindow_h
#define harmony_widgets_bubblewindow_h

#include "libwidgets.h"

#include <InterViews/window.h>

class Brush;
class Color;
class Glyph;


//<class>
//
// Name: BubbleWindow
//
// Purpose: creates a popup window with bubble style and shading around the bubble
//
// Public Interface:
//
// - BubbleWindow(Glyph*)
//   Constructor. Creates a BubbleWindow with a contained glyph to be showed.
//
// - ~BubbleWindow()
//   Destructor.
//
// - shape(BubbleWindow::Shape)
//   Defines if the outline of the bubble is rounded or squary.
//
// - bump(Coord bump_x,Coord bump_y,Coord distance_x,Coord distance_y)
//   Defines the outline geometry of the bubble if it is rounded.
//
// - direction(BubbleWindow::Direction,BubbleWindow::Direction);
//   Defines the direction how to show the bubble
//   (first parameter BubbleWindow::RIGHT or BubbleWindow::LEFT,
//   second parameter BubbleWindow::UP or BubbleWindow::DOWN).
//   
// - brush(Brush*)
//   Defines the brushstroke of the frame of the bubble.
//
// - background(const Color*)
//   Defines the background color of the bubble.
//
// - foreground(const Color*)
//   Defines the foreground (frame) color of the bubble.
//
// - map(void)
//   Use this to map the window.
//
// - repair(void);
//   Overloaded to draw the bubble. Do not use this.
//
// Description:
//
// BubbleWindow creates a popup window, which ist not under the control of the window
// manager, and the background is transparent.
// BubbleWindow shows its contained glyph in a bubble, which may be round or squary
// and can show in every direction (up ,down, left, right). The bubble has a shadowed
// outline, the frame of the bubble and the inner background of the bubble can be
// colored in any appropriate color. The size of the frame of the bubble can be set.
// In this implementation BubbleWindow pops up near the mouse coordinates in the right
// direction.
//
//</class>

class BubbleWindow : public PopupWindow
{
  public:
    enum Shape 
    {
      RECTANGLE=0,OVAL=1
    };
    enum Direction
    {
      RIGHT=0,LEFT=1,
      UP=0,DOWN=1
    };
    BubbleWindow(Glyph*);
    virtual ~BubbleWindow();
    void shape(Shape);
    void bump(Coord bump_x,Coord bump_y,Coord distance_x,Coord distance_y);
    void direction(Direction,Direction);
    void brush(Brush*);
    void background(const Color*);
    void foreground(const Color*);
    virtual void map(void);
    virtual void repair(void);

  private:    
    int align_x_;
    int align_y_;
    int bubble_shape_;
    Coord bump_x_;
    Coord bump_y_;
    Coord distance_x_;
    Coord distance_y_;
    const Brush* p_brush_;
    const Color* p_background_color_;
    const Color* p_foreground_color_;
    const Color* p_shadow_color_;
    Glyph* p_glyph_;
};

#endif
