/*=========================================================================

  Program:   Visualization Toolkit
  Module:    $RCSfile: vtkUnstructuredGridVolumeRayCastFunction.h,v $
  Language:  C++
  Date:      $Date: 2003/11/25 06:06:45 $
  Version:   $Revision: 1.3 $

  Copyright (c) 1993-2002 Ken Martin, Will Schroeder, Bill Lorensen 
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

// .NAME vtkUnstructuredGridVolumeRayCastFunction - a superclass for ray casting functions

// .SECTION Description
// vtkUnstructuredGridVolumeRayCastFunction is a superclass for ray casting functions that 
// can be used within a vtkUnstructuredGridVolumeRayCastMapper. 

// .SECTION See Also

#ifndef __vtkUnstructuredGridVolumeRayCastFunction_h
#define __vtkUnstructuredGridVolumeRayCastFunction_h

#include "vtkObject.h"

class vtkRenderer;
class vtkVolume;

class VTK_RENDERING_EXPORT vtkUnstructuredGridVolumeRayCastFunction : public vtkObject
{
public:
  vtkTypeRevisionMacro(vtkUnstructuredGridVolumeRayCastFunction,vtkObject);
  virtual void PrintSelf(ostream& os, vtkIndent indent);

//BTX
  virtual void Initialize( vtkRenderer *ren, vtkVolume   *vol )=0;
  
  virtual void Finalize( )=0;

  virtual void CastRay( int x, int y, double bounds[2], float color[4] )=0;
//ETX


protected:
  vtkUnstructuredGridVolumeRayCastFunction() {};
  ~vtkUnstructuredGridVolumeRayCastFunction() {};

private:
  vtkUnstructuredGridVolumeRayCastFunction(const vtkUnstructuredGridVolumeRayCastFunction&);  // Not implemented.
  void operator=(const vtkUnstructuredGridVolumeRayCastFunction&);  // Not implemented.
};

#endif







