#include "xml-freemind.h"

#include <QMessageBox>
#include <QColor>
#include <QTextStream>
#include <iostream>

#include "misc.h"
#include "settings.h"
#include "linkablemapobj.h"
#include "version.h"

static BranchObj *lastBranch;
static FloatObj *lastFloat;
static OrnamentedObj *lastOO;

extern Settings settings;
extern QString vymVersion;

extern QString flagsPath;

bool parseFreemindHandler::startDocument()
{
    errorProt = "";
    state = StateInit;
    laststate = StateInit;
	stateStack.clear();
	stateStack.append(StateInit);
    branchDepth=0;
	isVymPart=false;
    return true;
}


QString parseFreemindHandler::parseHREF(QString href)
{
	QString type=href.section(":",0,0);
	QString path=href.section(":",1,1);
	if (!tmpDir.endsWith("/"))
		return tmpDir + "/" + path;
	else	
		return tmpDir + path;
}

bool parseFreemindHandler::startElement  ( const QString&, const QString&,
                    const QString& eName, const QXmlAttributes& atts ) 
{
    QColor col;
	/* Testing
	cout << "startElement <"<< eName.ascii()
		<<">  state="<<state 
		<<"  laststate="<<stateStack.last()
		<<"   loadMode="<<loadMode
	//	<<"       line="<<QXmlDefaultHandler::lineNumber().ascii()
		<<endl;
	*/	
	stateStack.append (state);	
    if ( state == StateInit && (eName == "map")  ) 
	{
        state = StateMap;
		if (!atts.value( "version").isEmpty() ) 
		{
			QString v="0.8.0";
			if (!checkVersion(atts.value("version"),v))
				QMessageBox::warning( 0, "Warning: Version Problem" ,
				   "<h3>Freemind map is newer than version " +v +" </h3>"
				   "<p>The map you are just trying to load was "
				   "saved using freemind " +atts.value("version")+". "
				   "The version of this vym can parse freemind " + v +"."); 
		}
		mc->addBranch();
		lastBranch=mc->getLastBranch();
		lastBranch->move2RelPos (200,0);
		lastBranch->setHeading ("  ");
		mc->addBranch();
		lastBranch=mc->getLastBranch();
		lastBranch->move2RelPos (-200,0);
		lastBranch->setHeading ("  ");
		lastBranch=mc;

	} else if ( eName == "node" &&  (state == StateMap || state == StateNode )) 
	{
		if (!atts.value( "POSITION").isEmpty() )
		{
			if (atts.value ("POSITION")=="left")
			{
				me->select ("bo:1");
				lastBranch=me->getSelectedBranch();
				if (lastBranch)
				{
					lastBranch->addBranch();
					lastBranch=lastBranch->getLastBranch();
					readNodeAttr (atts);
				}	
			} else if (atts.value ("POSITION")=="right")
			{
				me->select ("bo:0");
				lastBranch=me->getSelectedBranch();
				if (lastBranch)
				{
					lastBranch->addBranch();
					lastBranch=lastBranch->getLastBranch();
					readNodeAttr (atts);
				}	
			}
		} else
		{
			if (state!=StateMap)
			{
				lastBranch->addBranch();
				lastBranch=lastBranch->getLastBranch();
			}
			readNodeAttr (atts);
		}
		state=StateNode;
	} else if ( eName == "font" && state == StateNode) 
	{
		state=StateFont;
	} else if ( eName == "edge" && state == StateNode) 
	{
		state=StateEdge;
	} else if ( eName == "hook" && state == StateNode) 
	{
		state=StateHook;
	} else if ( eName == "icon" && state == StateNode) 
	{
		state=StateIcon;
		if (!atts.value("BUILTIN").isEmpty() )
		{
			QString f=atts.value("BUILTIN");
			QString v;
			if (f=="help")
				v="questionmark";
			else if (f=="messagebox_warning")
				v="freemind-warning"; 
			else if (f=="idea")
				v="lamp"; 
			else if (f=="button_ok")
				v="hook-green"; 
			else if (f=="button_cancel")
				v="cross-red"; 
			else if (f.contains("full-"))
				v=f.replace("full-","freemind-priority-"); 
			else if (f=="back")
				v="freemind-back"; 
			else if (f=="forward")
				v="freemind-forward"; 
			else if (f=="attach")
				v="freemind-attach"; 
			else if (f=="ksmiletris")
				v="smiley-good"; // 
			else if (f=="clanbomber")
				v="freemind-clanbomber"; 
			else if (f=="desktop_new")
				v="freemind-desktopnew"; 
			else if (f=="flag")
				v="freemind-flag"; 
			else if (f=="gohome")
				v="freemind-gohome"; 
			else if (f=="kaddressbook")
				v="freemind-kaddressbook"; 
			else if (f=="knotify")
				v="freemind-knotify"; 
			else if (f=="korn")
				v="freemind-korn";
			else if (f=="Mail")
				v="freemind-mail"; 
			else if (f=="password")
				v="freemind-password"; 
			else if (f=="pencil")
				v="freemind-pencil";
			else if (f=="stop")
				v="freemind-stop"; 
			else if (f=="wizard")
				v="freemind-wizard";
			else if (f=="xmag")
				v="freemind-xmag";
			else if (f=="bell")
				v="freemind-bell";
			else if (f=="bookmark")
				v="freemind-bookmark"; 
			else if (f=="penguin")
				v="freemind-penguin"; 
			else if (f=="licq")
				v="freemind-licq"; 

			lastBranch->activateStandardFlag( v);
		}
	} else if ( eName == "arrowlink" && state == StateNode) 
	{
		state=StateArrowLink;
	} else if ( eName == "cloud" && state == StateNode) 
	{
		state=StateCloud;
	} else if ( eName == "text" && state == StateHook) 
	{
		state=StateText;
	} else 
        return false;   // Error
    return true;
}

bool parseFreemindHandler::endElement  ( const QString&, const QString&, const QString &eName)
{
	/* Testing
	cout << "endElement </" <<eName.ascii()
		<<">  state=" <<state 
		<<"  laststate=" <<laststate
		<<"  stateStack="<<stateStack.last() 
		<<endl;
	*/
    switch ( state ) 
	{
        case StateNode: 
			lastBranch=(BranchObj*)(lastBranch->getParObj());
            break;
		default: 
			break;
    }  
	state=stateStack.takeLast();	
	return true;
}

bool parseFreemindHandler::characters   ( const QString& ch)
{
	//cout << "characters \""<<ch.ascii()<<"\"  state="<<state <<"  laststate="<<laststate<<endl;

	QString ch_org=quotemeta (ch);
    QString ch_simplified=ch.simplifyWhiteSpace();
    if ( ch_simplified.isEmpty() ) return true;

    switch ( state ) 
    {
        case StateInit: break;
        case StateMap: break; 
        case StateNode: break; 
        case StateCloud: break; 
        case StateEdge: break; 
        case StateIcon: break; 
        case StateArrowLink: break; 
        case StateFont: break; 
        case StateHook: break; 
        case StateText: 
			lastBranch->setNote (ch_simplified);
			break; 
        default: 
			return false;
    }
    return true;
}

QString parseFreemindHandler::errorString() 
{
    return "the document is not in the Freemind file format";
}

bool parseFreemindHandler::readNodeAttr (const QXmlAttributes& a)
{
	lastOO=lastBranch;

	if (a.value( "FOLDED")=="true" )
		lastBranch->toggleScroll();
	if (!a.value( "TEXT").isEmpty() )
		lastBranch->setHeading (a.value ("TEXT"));

	if (!a.value( "COLOR").isEmpty() )
		lastBranch->setColor (QColor (a.value ("COLOR")));

	if (!a.value( "LINK").isEmpty() )
		lastBranch->setURL (a.value ("LINK"));

	return true;	
}


