/*
    This file is part of Waiho (http://info.xdev.org/projets/waiho)
    Copyright (C) 2001-2002 Nicolas Roard (nicolas@roard.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdio.h>
#include <stdlib.h>

#include <sys/socket.h>
#include <sys/unistd.h>

#include <errno.h>
#include <netdb.h>

#include <netinet/in.h>
#include <arpa/inet.h>

#include "ftpparse.h"
#import "file.h"

#define RaiseNetworkException(msg) [NSException raise: @"NetworkException" format: \
        [NSString stringWithFormat: @"%s [errno(%d) : %s]",msg,errno,strerror(errno)]]

@interface FTP: NSObject
{
	NSFileHandle* PI;
	NSFileHandle* DTP;
	NSString* Login;
	NSString* Password;
	NSString* FileName;

	int masize;
	int _idfile;
}

/* Initialisation */

+alloc;
-init;
-initWithAddress: (NSString*) adr;
-initWithAddress: (NSString*) adr withLogin: (NSString*) login withPassword: (NSString*) passwd;
- (BOOL) isConnected;
- (void) close;
- (void) shutdown;

- (NSArray*) list: (NSString*) str;

- (int) ret;
- (void) pasv;
- (int) command: (NSString*) str;
- (int) command: (NSString*) str withParam: (NSString*) param;

- (int) cd: (NSString*) str;
- (int) get: (NSString*) str withID: (int) idfile;
- (int) get: (NSString*) str withSavedName: (NSString*) name withID: (int) idfile;
- (int) put: (NSString*) str withSavedName: (NSString*) name withID: (int) idfile;
- (int) size: (NSString*) str;

- (void) downloadThread: (NSString*) filename;
- (void) uploadThread: (NSData*) data;

- (NSString*) readLineFrom: (NSFileHandle*) FH;
- (int)  createSocket: (NSString*) hostname withPort: (int) port;

@end
