// Copyright (c) The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// Authors: Malolan Chetlur             mal@ececs.uc.edu
//          Jorgen Dahl                 dahlj@ececs.uc.edu
//          Dale E. Martin              dmartin@cliftonlabs.com
//          Radharamanan Radhakrishnan  ramanan@ececs.uc.edu
//          Dhananjai Madhava Rao       dmadhava@ececs.uc.edu
//          Philip A. Wilsey            phil.wilsey@uc.edu

//---------------------------------------------------------------------------
// 
// $Id: EventSetFactory.cpp
// 
//---------------------------------------------------------------------------

#include "EventSetFactory.h"
#include "EventSet.h"
#include "SplayTree.h"
#include "SingleLinkedList.h"
#include "SimulationConfiguration.h"
#include "TimeWarpSimulationManager.h"
#include <clutils/ConfigurationChoice.h>
#include <clutils/Debug.h>
#include <clutils/StringUtilities.h>

using std::cerr;
using std::endl;

EventSetFactory::EventSetFactory(){}

EventSetFactory::~EventSetFactory(){}

Configurable *
EventSetFactory::allocate( SimulationConfiguration &configuration,
			   Configurable *parent ) const {
  SimulationManager *mySimulationManager = 
    dynamic_cast<SimulationManager *>(parent);
  ASSERT( mySimulationManager != 0 );
 
  EventSet *retval = 0;
  // the following cases are possible:

  // (1) only a event set choice is specified, in which case we
  // proceed assuming that only a centralized event set is desired.

  // (2) following the event set choice, the word "all" is specified
  // meaning that a separate event set is to be maintained for each
  // simulation object.

  if( configuration.eventListTypeIs( SplayTree::getType() ) ){
    retval = new SplayTree();
    clutils::debug << "Configured a SplayTree as the event set" << endl;
  }
  else if( configuration.eventListTypeIs( SingleLinkedList::getType() ) ){
    retval = new SingleLinkedList();
    clutils::debug << "Configured a SingleLinkedList as the event set" << endl;
  }
  else {
    mySimulationManager->shutdown( "Invalid EventList configuration value - \"" + 
				   configuration.getEventListType() + "\"" );
  }

  return retval;
}

const EventSetFactory *
EventSetFactory::instance(){
  static EventSetFactory *singleton = new EventSetFactory();
  return singleton;
}


