/* ctry.h */

#define IDX_2C(c1,c2)       (((c1-'a'+1)<<5)+(c2-'a'+1) )
#define IDX_3C(c1,c2,c3)    (((c1-'a'+1)<<10)+((c2-'a'+1)<<5)+(c3-'a'+1) )
#define IDX_4C(c1,c2,c3,c4) (((c1-'a'+1)<<15)+((c2-'a'+1)<<10)+((c3-'a'+1)<<5)+(c4-'a'+1) )

typedef struct country_code *CLISTPTR;

/***********************************************
 * Everything below here has been moved to the *
 * Language specific file webalizer_lang.h     *
 * This remains for reference only...          *
 ***********************************************

struct	country_code { u_long idx;
                         char *desc;
                       u_long count;
                       u_long files;
                       double  xfer;
                     } ctry[] = {

{ 0,                      "Unresolved/Unknown",               0,0,0 },
{ IDX_3C('c','o','m'),    "US Commercial",                    0,0,0 },
{ IDX_3C('e','d','u'),    "US Educational",                   0,0,0 },
{ IDX_3C('g','o','v'),    "US Government",                    0,0,0 },
{ IDX_3C('i','n','t'),    "International (int)",              0,0,0 },
{ IDX_3C('m','i','l'),    "US Military",                      0,0,0 },
{ IDX_3C('n','e','t'),    "Network",                          0,0,0 },
{ IDX_3C('o','r','g'),    "Non-Profit Organization",          0,0,0 },
{ IDX_4C('a','r','p','a'),"Old style Arpanet (arpa)",         0,0,0 },
{ IDX_4C('n','a','t','o'),"Nato field (nato)",                0,0,0 },
{ IDX_2C('a','d'),        "Andorra",                          0,0,0 },
{ IDX_2C('a','e'),        "United Arab Emirates",             0,0,0 },
{ IDX_2C('a','f'),        "Afghanistan",                      0,0,0 },
{ IDX_2C('a','g'),        "Antigua and Barbuda",              0,0,0 },
{ IDX_2C('a','i'),        "Anguilla",                         0,0,0 },
{ IDX_2C('a','l'),        "Albania",                          0,0,0 },
{ IDX_2C('a','m'),        "Armenia",                          0,0,0 },
{ IDX_2C('a','n'),        "Netherlands Antilles",             0,0,0 },
{ IDX_2C('a','o'),        "Angola",                           0,0,0 },
{ IDX_2C('a','q'),        "Antarctica",                       0,0,0 },
{ IDX_2C('a','r'),        "Argentina",                        0,0,0 },
{ IDX_2C('a','s'),        "American Samoa",                   0,0,0 },
{ IDX_2C('a','t'),        "Austria",                          0,0,0 },
{ IDX_2C('a','u'),        "Australia",                        0,0,0 },
{ IDX_2C('a','w'),        "Aruba",                            0,0,0 },
{ IDX_2C('a','z'),        "Azerbaijan",                       0,0,0 },
{ IDX_2C('b','a'),        "Bosnia and Herzegovina",           0,0,0 },
{ IDX_2C('b','b'),        "Barbados",                         0,0,0 },
{ IDX_2C('b','d'),        "Bangladesh",                       0,0,0 },
{ IDX_2C('b','e'),        "Belgium",                          0,0,0 },
{ IDX_2C('b','f'),        "Burkina Faso",                     0,0,0 },
{ IDX_2C('b','g'),        "Bulgaria",                         0,0,0 },
{ IDX_2C('b','h'),        "Bahrain",                          0,0,0 },
{ IDX_2C('b','i'),        "Burundi",                          0,0,0 },
{ IDX_2C('b','j'),        "Benin",                            0,0,0 },
{ IDX_2C('b','m'),        "Bermuda",                          0,0,0 },
{ IDX_2C('b','n'),        "Brunei Darussalam",                0,0,0 },
{ IDX_2C('b','o'),        "Bolivia",                          0,0,0 },
{ IDX_2C('b','r'),        "Brazil",                           0,0,0 },
{ IDX_2C('b','s'),        "Bahamas",                          0,0,0 },
{ IDX_2C('b','t'),        "Bhutan",                           0,0,0 },
{ IDX_2C('b','v'),        "Bouvet Island",                    0,0,0 },
{ IDX_2C('b','w'),        "Botswana",                         0,0,0 },
{ IDX_2C('b','y'),        "Belarus",                          0,0,0 },
{ IDX_2C('b','z'),        "Belize",                           0,0,0 },
{ IDX_2C('c','a'),        "Canada",                           0,0,0 },
{ IDX_2C('c','c'),        "Cocos (Keeling) Islands",          0,0,0 },
{ IDX_2C('c','f'),        "Central African Republic",         0,0,0 },
{ IDX_2C('c','g'),        "Congo",                            0,0,0 },
{ IDX_2C('c','h'),        "Switzerland",                      0,0,0 },
{ IDX_2C('c','i'),        "Cote D'Ivoire (Ivory Coast)",      0,0,0 },
{ IDX_2C('c','k'),        "Cook Islands",                     0,0,0 },
{ IDX_2C('c','l'),        "Chile",                            0,0,0 },
{ IDX_2C('c','m'),        "Cameroon",                         0,0,0 },
{ IDX_2C('c','n'),        "China",                            0,0,0 },
{ IDX_2C('c','o'),        "Colombia",                         0,0,0 },
{ IDX_2C('c','r'),        "Costa Rica",                       0,0,0 },
{ IDX_2C('c','s'),        "Czechoslovakia (former)",          0,0,0 },
{ IDX_2C('c','u'),        "Cuba",                             0,0,0 },
{ IDX_2C('c','v'),        "Cape Verde",                       0,0,0 },
{ IDX_2C('c','x'),        "Christmas Island",                 0,0,0 },
{ IDX_2C('c','y'),        "Cyprus",                           0,0,0 },
{ IDX_2C('c','z'),        "Czech Republic",                   0,0,0 },
{ IDX_2C('d','e'),        "Germany",                          0,0,0 },
{ IDX_2C('d','j'),        "Djibouti",                         0,0,0 },
{ IDX_2C('d','k'),        "Denmark",                          0,0,0 },
{ IDX_2C('d','m'),        "Dominica",                         0,0,0 },
{ IDX_2C('d','o'),        "Dominican Republic",               0,0,0 },
{ IDX_2C('d','z'),        "Algeria",                          0,0,0 },
{ IDX_2C('e','c'),        "Ecuador",                          0,0,0 },
{ IDX_2C('e','e'),        "Estonia",                          0,0,0 },
{ IDX_2C('e','g'),        "Egypt",                            0,0,0 },
{ IDX_2C('e','h'),        "Western Sahara",                   0,0,0 },
{ IDX_2C('e','r'),        "Eritrea",                          0,0,0 },
{ IDX_2C('e','s'),        "Spain",                            0,0,0 },
{ IDX_2C('e','t'),        "Ethiopia",                         0,0,0 },
{ IDX_2C('f','i'),        "Finland",                          0,0,0 },
{ IDX_2C('f','j'),        "Fiji",                             0,0,0 },
{ IDX_2C('f','k'),        "Falkland Islands (Malvinas)",      0,0,0 },
{ IDX_2C('f','m'),        "Micronesia",                       0,0,0 },
{ IDX_2C('f','o'),        "Faroe Islands",                    0,0,0 },
{ IDX_2C('f','r'),        "France",                           0,0,0 },
{ IDX_2C('f','x'),        "France, Metropolitan",             0,0,0 },
{ IDX_2C('g','a'),        "Gabon",                            0,0,0 },
{ IDX_2C('g','b'),        "Great Britain (UK)",               0,0,0 },
{ IDX_2C('g','d'),        "Grenada",                          0,0,0 },
{ IDX_2C('g','e'),        "Georgia",                          0,0,0 },
{ IDX_2C('g','f'),        "French Guiana",                    0,0,0 },
{ IDX_2C('g','h'),        "Ghana",                            0,0,0 },
{ IDX_2C('g','i'),        "Gibraltar",                        0,0,0 },
{ IDX_2C('g','l'),        "Greenland",                        0,0,0 },
{ IDX_2C('g','m'),        "Gambia",                           0,0,0 },
{ IDX_2C('g','n'),        "Guinea",                           0,0,0 },
{ IDX_2C('g','p'),        "Guadeloupe",                       0,0,0 },
{ IDX_2C('g','q'),        "Equatorial Guinea",                0,0,0 },
{ IDX_2C('g','r'),        "Greece",                           0,0,0 },
{ IDX_2C('g','s'),        "S. Georgia and S. Sandwich Isls.", 0,0,0 },
{ IDX_2C('g','t'),        "Guatemala",                        0,0,0 },
{ IDX_2C('g','u'),        "Guam",                             0,0,0 },
{ IDX_2C('g','w'),        "Guinea-Bissau",                    0,0,0 },
{ IDX_2C('g','y'),        "Guyana",                           0,0,0 },
{ IDX_2C('h','k'),        "Hong Kong",                        0,0,0 },
{ IDX_2C('h','m'),        "Heard and McDonald Islands",       0,0,0 },
{ IDX_2C('h','n'),        "Honduras",                         0,0,0 },
{ IDX_2C('h','r'),        "Croatia (Hrvatska)",               0,0,0 },
{ IDX_2C('h','t'),        "Haiti",                            0,0,0 },
{ IDX_2C('h','u'),        "Hungary",                          0,0,0 },
{ IDX_2C('i','d'),        "Indonesia",                        0,0,0 },
{ IDX_2C('i','e'),        "Ireland",                          0,0,0 },
{ IDX_2C('i','l'),        "Israel",                           0,0,0 },
{ IDX_2C('i','n'),        "India",                            0,0,0 },
{ IDX_2C('i','o'),        "British Indian Ocean Territory",   0,0,0 },
{ IDX_2C('i','q'),        "Iraq",                             0,0,0 },
{ IDX_2C('i','r'),        "Iran",                             0,0,0 },
{ IDX_2C('i','s'),        "Iceland",                          0,0,0 },
{ IDX_2C('i','t'),        "Italy",                            0,0,0 },
{ IDX_2C('j','m'),        "Jamaica",                          0,0,0 },
{ IDX_2C('j','o'),        "Jordan",                           0,0,0 },
{ IDX_2C('j','p'),        "Japan",                            0,0,0 },
{ IDX_2C('k','e'),        "Kenya",                            0,0,0 },
{ IDX_2C('k','g'),        "Kyrgyzstan",                       0,0,0 },
{ IDX_2C('k','h'),        "Cambodia",                         0,0,0 },
{ IDX_2C('k','i'),        "Kiribati",                         0,0,0 },
{ IDX_2C('k','m'),        "Comoros",                          0,0,0 },
{ IDX_2C('k','n'),        "Saint Kitts and Nevis",            0,0,0 },
{ IDX_2C('k','p'),        "Korea (North)",                    0,0,0 },
{ IDX_2C('k','r'),        "Korea (South)",                    0,0,0 },
{ IDX_2C('k','w'),        "Kuwait",                           0,0,0 },
{ IDX_2C('k','y'),        "Cayman Islands",                   0,0,0 },
{ IDX_2C('k','z'),        "Kazakhstan",                       0,0,0 },
{ IDX_2C('l','a'),        "Laos",                             0,0,0 },
{ IDX_2C('l','b'),        "Lebanon",                          0,0,0 },
{ IDX_2C('l','c'),        "Saint Lucia",                      0,0,0 },
{ IDX_2C('l','i'),        "Liechtenstein",                    0,0,0 },
{ IDX_2C('l','k'),        "Sri Lanka",                        0,0,0 },
{ IDX_2C('l','r'),        "Liberia",                          0,0,0 },
{ IDX_2C('l','s'),        "Lesotho",                          0,0,0 },
{ IDX_2C('l','t'),        "Lithuania",                        0,0,0 },
{ IDX_2C('l','u'),        "Luxembourg",                       0,0,0 },
{ IDX_2C('l','v'),        "Latvia",                           0,0,0 },
{ IDX_2C('l','y'),        "Libya",                            0,0,0 },
{ IDX_2C('m','a'),        "Morocco",                          0,0,0 },
{ IDX_2C('m','c'),        "Monaco",                           0,0,0 },
{ IDX_2C('m','d'),        "Moldova",                          0,0,0 },
{ IDX_2C('m','g'),        "Madagascar",                       0,0,0 },
{ IDX_2C('m','h'),        "Marshall Islands",                 0,0,0 },
{ IDX_2C('m','k'),        "Macedonia",                        0,0,0 },
{ IDX_2C('m','l'),        "Mali",                             0,0,0 },
{ IDX_2C('m','m'),        "Myanmar",                          0,0,0 },
{ IDX_2C('m','n'),        "Mongolia",                         0,0,0 },
{ IDX_2C('m','o'),        "Macau",                            0,0,0 },
{ IDX_2C('m','p'),        "Northern Mariana Islands",         0,0,0 },
{ IDX_2C('m','q'),        "Martinique",                       0,0,0 },
{ IDX_2C('m','r'),        "Mauritania",                       0,0,0 },
{ IDX_2C('m','s'),        "Montserrat",                       0,0,0 },
{ IDX_2C('m','t'),        "Malta",                            0,0,0 },
{ IDX_2C('m','u'),        "Mauritius",                        0,0,0 },
{ IDX_2C('m','v'),        "Maldives",                         0,0,0 },
{ IDX_2C('m','w'),        "Malawi",                           0,0,0 },
{ IDX_2C('m','x'),        "Mexico",                           0,0,0 },
{ IDX_2C('m','y'),        "Malaysia",                         0,0,0 },
{ IDX_2C('m','z'),        "Mozambique",                       0,0,0 },
{ IDX_2C('n','a'),        "Namibia",                          0,0,0 },
{ IDX_2C('n','c'),        "New Caledonia",                    0,0,0 },
{ IDX_2C('n','e'),        "Niger",                            0,0,0 },
{ IDX_2C('n','f'),        "Norfolk Island",                   0,0,0 },
{ IDX_2C('n','g'),        "Nigeria",                          0,0,0 },
{ IDX_2C('n','i'),        "Nicaragua",                        0,0,0 },
{ IDX_2C('n','l'),        "Netherlands",                      0,0,0 },
{ IDX_2C('n','o'),        "Norway",                           0,0,0 },
{ IDX_2C('n','p'),        "Nepal",                            0,0,0 },
{ IDX_2C('n','r'),        "Nauru",                            0,0,0 },
{ IDX_2C('n','t'),        "Neutral Zone",                     0,0,0 },
{ IDX_2C('n','u'),        "Niue",                             0,0,0 },
{ IDX_2C('n','z'),        "New Zealand (Aotearoa)",           0,0,0 },
{ IDX_2C('o','m'),        "Oman",                             0,0,0 },
{ IDX_2C('p','a'),        "Panama",                           0,0,0 },
{ IDX_2C('p','e'),        "Peru",                             0,0,0 },
{ IDX_2C('p','f'),        "French Polynesia",                 0,0,0 },
{ IDX_2C('p','g'),        "Papua New Guinea",                 0,0,0 },
{ IDX_2C('p','h'),        "Philippines",                      0,0,0 },
{ IDX_2C('p','k'),        "Pakistan",                         0,0,0 },
{ IDX_2C('p','l'),        "Poland",                           0,0,0 },
{ IDX_2C('p','m'),        "St. Pierre and Miquelon",          0,0,0 },
{ IDX_2C('p','n'),        "Pitcairn",                         0,0,0 },
{ IDX_2C('p','r'),        "Puerto Rico",                      0,0,0 },
{ IDX_2C('p','t'),        "Portugal",                         0,0,0 },
{ IDX_2C('p','w'),        "Palau",                            0,0,0 },
{ IDX_2C('p','y'),        "Paraguay",                         0,0,0 },
{ IDX_2C('q','a'),        "Qatar",                            0,0,0 },
{ IDX_2C('r','e'),        "Reunion",                          0,0,0 },
{ IDX_2C('r','o'),        "Romania",                          0,0,0 },
{ IDX_2C('r','u'),        "Russian Federation",               0,0,0 },
{ IDX_2C('r','w'),        "Rwanda",                           0,0,0 },
{ IDX_2C('s','a'),        "Saudi Arabia",                     0,0,0 },
{ IDX_2C('s','B'),        "Solomon Islands",                  0,0,0 },
{ IDX_2C('s','c'),        "Seychelles",                       0,0,0 },
{ IDX_2C('s','d'),        "Sudan",                            0,0,0 },
{ IDX_2C('s','e'),        "Sweden",                           0,0,0 },
{ IDX_2C('s','g'),        "Singapore",                        0,0,0 },
{ IDX_2C('s','h'),        "St. Helena",                       0,0,0 },
{ IDX_2C('s','i'),        "Slovenia",                         0,0,0 },
{ IDX_2C('s','j'),        "Svalbard and Jan Mayen Islands",   0,0,0 },
{ IDX_2C('s','k'),        "Slovak Republic",                  0,0,0 },
{ IDX_2C('s','l'),        "Sierra Leone",                     0,0,0 },
{ IDX_2C('s','m'),        "San Marino",                       0,0,0 },
{ IDX_2C('s','n'),        "Senegal",                          0,0,0 },
{ IDX_2C('s','o'),        "Somalia",                          0,0,0 },
{ IDX_2C('s','r'),        "Suriname",                         0,0,0 },
{ IDX_2C('s','t'),        "Sao Tome and Principe",            0,0,0 },
{ IDX_2C('s','u'),        "USSR (former)",                    0,0,0 },
{ IDX_2C('s','v'),        "El Salvador",                      0,0,0 },
{ IDX_2C('s','y'),        "Syria",                            0,0,0 },
{ IDX_2C('s','z'),        "Swaziland",                        0,0,0 },
{ IDX_2C('t','c'),        "Turks and Caicos Islands",         0,0,0 },
{ IDX_2C('t','d'),        "Chad",                             0,0,0 },
{ IDX_2C('t','f'),        "French Southern Territories",      0,0,0 },
{ IDX_2C('t','g'),        "Togo",                             0,0,0 },
{ IDX_2C('t','h'),        "Thailand",                         0,0,0 },
{ IDX_2C('t','j'),        "Tajikistan",                       0,0,0 },
{ IDX_2C('t','k'),        "Tokelau",                          0,0,0 },
{ IDX_2C('t','m'),        "Turkmenistan",                     0,0,0 },
{ IDX_2C('t','n'),        "Tunisia",                          0,0,0 },
{ IDX_2C('t','o'),        "Tonga",                            0,0,0 },
{ IDX_2C('t','p'),        "East Timor",                       0,0,0 },
{ IDX_2C('t','r'),        "Turkey",                           0,0,0 },
{ IDX_2C('t','t'),        "Trinidad and Tobago",              0,0,0 },
{ IDX_2C('t','v'),        "Tuvalu",                           0,0,0 },
{ IDX_2C('t','w'),        "Taiwan",                           0,0,0 },
{ IDX_2C('t','z'),        "Tanzania",                         0,0,0 },
{ IDX_2C('u','a'),        "Ukraine",                          0,0,0 },
{ IDX_2C('u','g'),        "Uganda",                           0,0,0 },
{ IDX_2C('u','k'),        "United Kingdom",                   0,0,0 },
{ IDX_2C('u','m'),        "US Minor Outlying Islands",        0,0,0 },
{ IDX_2C('u','s'),        "United States",                    0,0,0 },
{ IDX_2C('u','y'),        "Uruguay",                          0,0,0 },
{ IDX_2C('u','z'),        "Uzbekistan",                       0,0,0 },
{ IDX_2C('v','a'),        "Vatican City State (Holy See)",    0,0,0 },
{ IDX_2C('v','c'),        "Saint Vincent and the Grenadines", 0,0,0 },
{ IDX_2C('v','e'),        "Venezuela",                        0,0,0 },
{ IDX_2C('v','g'),        "Virgin Islands (British)",         0,0,0 },
{ IDX_2C('v','i'),        "Virgin Islands (U.S.)",            0,0,0 },
{ IDX_2C('v','n'),        "Viet Nam",                         0,0,0 },
{ IDX_2C('v','u'),        "Vanuatu",                          0,0,0 },
{ IDX_2C('w','f'),        "Wallis and Futuna Islands",        0,0,0 },
{ IDX_2C('w','s'),        "Samoa",                            0,0,0 },
{ IDX_2C('y','e'),        "Yemen",                            0,0,0 },
{ IDX_2C('y','t'),        "Mayotte",                          0,0,0 },
{ IDX_2C('y','u'),        "Yugoslavia",                       0,0,0 },
{ IDX_2C('z','a'),        "South Africa",                     0,0,0 },
{ IDX_2C('z','m'),        "Zambia",                           0,0,0 },
{ IDX_2C('z','r'),        "Zaire",                            0,0,0 },
{ IDX_2C('z','w'),        "Zimbabwe",                         0 ,0,0}};

#define MAX_CTRY (int)(sizeof(ctry)/sizeof(struct country_code))

*/
