import pygtk
import gtk
import gtk.glade

from util import find_glade_file

class PreferenceDialog:
    def __init__(self, config):
        # setup the preferences glade interface
        self.glade = gtk.glade.XML(find_glade_file("wbconfig.glade"))
        self.glade.signal_autoconnect(self)
        self.dialog = self.glade.get_widget("dialog_preferences")
        self.pastebin_entry = self.glade.get_widget("entry_url")
        self.pastebin_entry.connect('changed', self.pastebin_entry_changed_cb)
        self.user_entry = self.glade.get_widget("entry_user")
        self.user_entry.connect('changed', self.user_entry_changed_cb)
        self.close_button = self.glade.get_widget("button_close")
        self.close_button.connect("clicked", self.on_button_close_clicked)

        self.config = config

    def show(self, *args):
        self.pastebin_entry.set_sensitive(self.config.pastebin_is_writable())
        self.pastebin_entry.set_text(self.config.pastebin)
        self.user_entry.set_sensitive(self.config.user_is_writable())
        self.user_entry.set_text(self.config.user)
        self.dialog.show()

    def user_entry_changed_cb(self, entry, *args):
        user = self.user_entry.get_text()
        self.config.set_user(user)

    def pastebin_entry_changed_cb(self, entry, *args):
        pastebin = self.pastebin_entry.get_text()
        self.config.set_pastebin(pastebin)

    def on_button_close_clicked(self, widget, *args):
        self.dialog.hide()

    def on_dialog_preferences_delete_event(self, widget, *args):
        self.dialog.hide()
        return True
