/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2008 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#include "definitioninfo.h"

#include <QStringList>

using namespace WebIssues;

DefinitionInfo::DefinitionInfo() :
    m_type( Invalid ),
    m_required( false )
{
}

DefinitionInfo::~DefinitionInfo()
{
}

void DefinitionInfo::setMetadata( const QString& key, const QVariant& value )
{
    if ( value.isNull() )
        m_metadata.remove( key );
    else
        m_metadata.insert( key, value );
}

QVariant DefinitionInfo::metadata( const QString& key ) const
{
    QMap<QString, QVariant>::const_iterator it = m_metadata.find( key );
    if ( it == m_metadata.end() )
        return QVariant();
    return *it;
}

QStringList DefinitionInfo::metadataKeys() const
{
    return m_metadata.keys();
}
