/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2008 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#include "connectioninfodialog.h"

#include <QLayout>
#include <QDialogButtonBox>

#include "commands/commandmanager.h"
#include "data/datamanager.h"
#include "data/connectioninfo.h"
#include "widgets/propertypanel.h"
#include "connectionmanager.h"

using namespace WebIssues;

/* TRANSLATOR WebIssues::ConnectionInfoDialog */

ConnectionInfoDialog::ConnectionInfoDialog( QWidget* parent ) : QDialog( parent )
{
    setWindowTitle( tr( "Connection Details" ) );

    QVBoxLayout* layout = new QVBoxLayout( this );

    m_panel = new PropertyPanel( this );
    m_panel->setInnerMargin( 0 );

    m_panel->addProperty( "url", tr( "URL:" ) );
    m_panel->addProperty( "serverName", tr( "Server name:" ) );
    m_panel->addProperty( "version", tr( "Version:" ) );
    m_panel->addSeparator();
    m_panel->addProperty( "login", tr( "Login:" ) );
    m_panel->addProperty( "userName", tr( "User name:" ) );
    m_panel->addProperty( "access", tr( "Access:" ) );

    layout->addWidget( m_panel );

    layout->addSpacing( 10 );

    QDialogButtonBox* buttonBox = new QDialogButtonBox( QDialogButtonBox::Ok, Qt::Horizontal, this );
    buttonBox->setCenterButtons( true );
    layout->addWidget( buttonBox );

    connect( buttonBox, SIGNAL( accepted() ), this, SLOT( accept() ) );

    updateInformation();

    setFixedSize( sizeHint() );
}

ConnectionInfoDialog::~ConnectionInfoDialog()
{
}

void ConnectionInfoDialog::updateInformation()
{
    m_panel->setValue( "url", commandManager->serverUrl().toString() );
    m_panel->setValue( "serverName", connectionManager->connectionInfo()->serverName() );

    QString version = commandManager->serverVersion();
    m_panel->setValue( "version", version.isEmpty() ? tr( "0.8.2 or older" ) : version );

    int userId = connectionManager->connectionInfo()->userId();
    const UserRow* user = dataManager->users()->find( userId );

    m_panel->setValue( "login", user ? user->login() : QString() );
    m_panel->setValue( "userName", user ? user->name() : QString() );

    Access access = connectionManager->connectionInfo()->access();
    m_panel->setValue( "access", ( access == AdminAccess ) ? tr( "Administrator" ) : tr( "Regular" ) );
}
