/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2008 WebIssues Team
*
* This file is derived from the QtDotNet Style v2.0, a Qt Solutions
* component. See original copyright information below.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

/****************************************************************************
**
** Copyright (C) 2003-2007 Trolltech ASA. All rights reserved.
**
** This file is part of a Qt Solutions component.
**
** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** Trolltech sales department at sales@trolltech.com.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef DOTNETSTYLE_H
#define DOTNETSTYLE_H

#include <QtGlobal>

#if !defined( Q_WS_WIN ) || ( QT_VERSION < 0x040300 ) || defined( QT_NO_STYLE_WINDOWSVISTA )
#define WI_NO_STYLE_DOTNET
#endif

#if !defined( WI_NO_STYLE_DOTNET )

#include <QWindowsVistaStyle>

class QLinearGradient;
class QBrush;

namespace WebIssues
{

/**
* Style for Windows with modern menus and toolbars similar to Office 2003.
*
* This code is derived from the QtDotNet Style v2.0, a Qt Solutions component.
*/
class DotNetStyle : public QWindowsVistaStyle
{
public:
    /**
    * Constructor.
    */
    DotNetStyle();

    /**
    * Destructor.
    */
    ~DotNetStyle();

public:
    /**
    * Fill the widget with a gradient background.
    */
    void fillGradient( const QStyleOption* option, QPainter* painter, const QWidget* widget );

public: // overrides
    void drawPrimitive( PrimitiveElement element, const QStyleOption* option,
        QPainter* painter, const QWidget* widget = 0 ) const;
    void drawControl( ControlElement element, const QStyleOption* option,
        QPainter* painter, const QWidget* widget ) const;
    void drawComplexControl( ComplexControl control, const QStyleOptionComplex* option,
        QPainter* painter, const QWidget* widget ) const;
    QSize sizeFromContents( ContentsType type, const QStyleOption* option,
        const QSize& size, const QWidget* widget ) const;

    QRect subElementRect( SubElement element, const QStyleOption* option, const QWidget* widget ) const;
    QRect subControlRect( ComplexControl cc, const QStyleOptionComplex* opt,
        SubControl sc, const QWidget* widget ) const;

    SubControl hitTestComplexControl( ComplexControl control, const QStyleOptionComplex* option,
	    const QPoint& pos, const QWidget* widget = 0 ) const;

    QPixmap standardPixmap( StandardPixmap standardPixmap, const QStyleOption* opt,
        const QWidget* widget = 0 ) const;
    int styleHint( StyleHint hint, const QStyleOption* option = 0, const QWidget* widget = 0,
        QStyleHintReturn* returnData = 0 ) const;
    int pixelMetric( PixelMetric metric, const QStyleOption* option = 0, const QWidget* widget = 0 ) const;

    void polish( QWidget* widget );
    void unpolish( QWidget* widget );
    void polish( QPalette& pal );
    void polish( QApplication* app );
    void unpolish( QApplication* app );

    QPalette standardPalette() const;

private:
    QColor gradientDarkColor( const QStyleOption* option ) const;
    QColor gradientLightColor( const QStyleOption* option ) const;
    QColor highlightOutlineColor( const QStyleOption* option, bool act = false ) const;
    QColor shadowColor( const QStyleOption* option ) const;

    QBrush highlightBrush( const QStyleOption* option, bool act ) const;
    QBrush highlightMenuCheckBrush( const QStyleOption* option, bool act ) const;
    QBrush highlightTabBrush( const QStyleOption* option, bool act ) const;

    QLinearGradient toolbarGradient( const QStyleOption* option, QRect rect, Qt::Orientation orientaion = Qt::Vertical ) const;
    QLinearGradient menuGradient( const QStyleOption* option, QRect rect, Qt::Orientation orientaion = Qt::Horizontal ) const;
    QLinearGradient tabGradient( const QStyleOption* option, QRect rect, Qt::Orientation orientaion = Qt::Horizontal ) const;

    void updatePalette();

private:
    enum InternalPalette
    {
        Blue,
        Silver,
        Olive,
        Classic
    };

private:
    QColor m_menuSeparatorColor;
    QColor m_menuBackgroundColor;
    QColor m_menuFrameColor;

    InternalPalette m_internalPalette;

    QPalette m_currentPal;
};

}

#endif

#endif
