/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2009 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef APPLICATION_H
#define APPLICATION_H

#include <QApplication>

class QUrl;

class MainWindow;

/**
* Class representing the WebIssues application.
*
* On startup the application creates the ConfigData
* and ConnectionManager objects, opens the MainWindow
* and restores the session or the last connection if necessary.
*
* On shutdown it destroys all objects.
*/
class Application : public QApplication
{
    Q_OBJECT
public:
    /**
    * Constructor.
    */
    Application( int& argc, char** argv );

    /**
    * Destructor.
    */
    ~Application();

public:
    /**
    * Return the URL of the manual index;
    */
    QUrl manualIndex() const;

    /**
    * Return the version of the application.
    */
    QString version() const;

    /**
    * Return the path of the data directory.
    */
    QString dataPath() const { return m_dataPath; }

    /**
    * Return the path of the cache directory.
    */
    QString cachePath() const { return m_cachePath; }

    /**
    * Return the path of the storage directory.
    */
    QString storagePath() const { return m_storagePath; }

public slots:
    /**
    * Show the About WebIssues dialog.
    */
    void about();

    /**
    * Open the WebIssues manual.
    */
    void manual();

public: // overrides
    void commitData( QSessionManager& manager );

private:
    bool loadTranslation( const QString& name, bool tryQtDir );

    void initializeDefaultPaths();
    void processArguments();

private:
    MainWindow* m_mainWindow;

    QString m_manualPath;
    QString m_translationsPath;

    QString m_configPath;

    QString m_dataPath;
    QString m_cachePath;
    QString m_storagePath;
};

#endif
