/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2009 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#include "panewidget.h"

#include <QLabel>
#include <QLayout>

PaneWidget::PaneWidget( QWidget* parent ) : QStackedWidget( parent ),
    m_mainWidget( NULL )
{
    m_labelWidget = new QWidget( this );
    m_label = new QLabel( m_labelWidget );

    QVBoxLayout* layout = new QVBoxLayout( m_labelWidget );
    layout->setContentsMargins( 0, 1, 0, 0 );
    layout->addWidget( m_label );

    m_label->setAlignment( Qt::AlignCenter );
    m_label->setSizePolicy( QSizePolicy::Ignored, QSizePolicy::Ignored );
#if defined( Q_WS_WIN )
    m_label->setFrameStyle( QFrame::StyledPanel | QFrame::Plain );
#endif

    addWidget( m_labelWidget );
}

PaneWidget::~PaneWidget()
{
}

void PaneWidget::setPlaceholderText( const QString& text )
{
    m_label->setText( text );
}

void PaneWidget::setMainWidget( QWidget* widget )
{
    delete m_mainWidget;
    m_mainWidget = widget;
    addWidget( widget );
}

void PaneWidget::setMainWidgetVisible( bool visible )
{
    setCurrentWidget( visible ? m_mainWidget : m_labelWidget );
}
