#!/usr/local/bin/perl
# Display a list of users whose passwords can be changed

require './passwd-lib.pl';
if (!&foreign_check("useradmin")) {
	&header($text{'index_title'}, "", undef, 1, 1);
	print "<hr>\n";
	print "<p>$text{'index_euseradmin'}<p>\n";
	print "<hr>\n";
	&footer("/", $text{'index'});
	exit;
	}
&foreign_require("useradmin", "user-lib.pl");

if ($access{'mode'} == 1) {
	if ($access{'users'} =~ /^\S+$/) {
		# Just one user - go to him
		&redirect("edit_passwd.cgi?user=$access{'users'}");
		exit;
		}
	map { $ucan{$_}++ } split(/\s+/, $access{'users'});
	}
elsif ($access{'mode'} == 2) {
	map { $ucannot{$_}++ } split(/\s+/, $access{'users'});
	}
elsif ($access{'mode'} == 3) {
	# Just this user - go to him
	&redirect("edit_passwd.cgi?user=$remote_user");
	exit;
	}
elsif ($access{'mode'} == 5) {
	map { $gcan{$gid = getgrnam($_)}++ } split(/\s+/, $access{'users'});
	}

&header($text{'index_title'}, "", undef, 1, 1);
print "<hr>\n";

# Show all unix users who can be edited
foreach $u (&foreign_call("useradmin", "list_users")) {
	if ($access{'mode'} == 0 ||
	    $access{'mode'} == 1 && $ucan{$u->{'user'}} ||
	    $access{'mode'} == 2 && !$ucannot{$u->{'user'}} ||
	    $access{'mode'} == 5 && $gcan{$u->{'gid'}} ||
	    $access{'mode'} == 6 && $u->{'user'} =~ /$access{'users'}/ ||
	    $access{'mode'} == 4 &&
		(!$access{'low'} || $u->{'uid'} >= $access{'low'}) &&
		(!$access{'high'} || $u->{'uid'} <= $access{'high'})) {
		push(@ulist, $u);
		}
	}
if ($config{'sort_mode'}) {
	@ulist = sort { $a->{'user'} cmp $b->{'user'} } @ulist;
	}
if ($config{'max_users'} && @ulist > $config{'max_users'}) {
	# Show as form for entering a username
	print "$text{'index_toomany'}<br>\n";
	print "<form action=edit_passwd.cgi>\n";
	print "<input type=submit value='$text{'index_user'}'>\n";
	if ($config{'input_type'}) {
		print "<select name=user>\n";
		foreach $u (@ulist) {
			print "<option>$u->{'user'}\n";
			}
		print "</select>\n";
		}
	else {
		print "<input name=user size=13> ",
		      &user_chooser_button("user",0);
		}
	print "</form>\n";
	}
else {
	# Show as table of users
	print "<table border width=100%>\n";
	print "<tr $tb> <td><b>$text{'index_header'}</b></td> </tr>\n";
	print "<tr $cb> <td><table width=100%>\n";
	for($i=0; $i<@ulist; $i++) {
		if ($i%4 == 0) { print "<tr>\n"; }
		print "<td width=25%><a href=\"edit_passwd.cgi?",
		      "idx=$ulist[$i]->{'num'}&user=$ulist[$i]->{'user'}\">",
		      &html_escape($ulist[$i]->{'user'})."</a></td>\n";
		if ($i%4 == 3) { print "</tr>\n"; }
		}
	while($i++ % 4) { print "<td width=25%></td>\n"; }
	print "</table></td> </tr></table><p>\n";
	}

print "<hr>\n";
&footer("/", $text{'index'});

