# ping-monitor.pl
# Ping some host

sub get_ping_status
{
# fork the ping process and wait for it to exit
$ping_exited = 0;
local $pid = fork();
if (!$pid) {
	#untie *STDIN; close(STDIN);
	#untie *STDOUT; close(STDOUT);
	#untie *STDERR; close(STDERR);
	exit system("$config{'ping_cmd'} $_[0]->{'host'} >/dev/null 2>&1 </dev/null");
	}
$SIG{'CHLD'} = "ping_reaper";
sleep(defined($_[0]->{'wait'}) ? $_[0]->{'wait'} : 5);
if ($ping_exited) {
	local $rv = waitpid($pid, WNOHANG);
	if ($?) {
		# ping exited with failure
		return { 'up' => 0 };
		}
	else {
		# ping sucessful
		return { 'up' => 1 };
		}
	}
else {
	# ping never finished!
	kill('TERM', $pid);
	return { 'up' => 0 };
	}
}

sub ping_reaper
{
$ping_exited++;
}


sub show_ping_dialog
{
print "<tr> <td><b>$text{'ping_host'}</b></td>\n";
print "<td colspan=3><input name=host size=45 value='$_[0]->{'host'}'></td> </tr>\n";

print "<tr> <td><b>$text{'ping_wait'}</b></td>\n";
printf "<td><input name=wait size=6 value='%s'></td> </tr>\n",
	defined($_[0]->{'wait'}) ? $_[0]->{'wait'} : 5;
}

sub parse_ping_dialog
{
$config{'ping_cmd'} || &error($text{'ping_econfig'});
&check_ipaddress($in{'host'}) || gethostbyname($in{'host'}) ||
	&error($text{'ping_ehost'});
$in{'wait'} =~ /^\d+$/ || &error($text{'ping_ewait'});
$_[0]->{'host'} = $in{'host'};
$_[0]->{'wait'} = $in{'wait'};
}

