#
# cookie.rb -- Cookie class
#
# Author: IPR -- Internet Programming with Ruby -- writers
# Copyright (C) 2000, 2001 TAKAHASHI Masayoshi, GOTOU Yuuzou
#
# $IPR: cookie.rb,v 1.10 2002/02/05 20:20:31 gotoyuzo Exp $

require 'webrick/httputils'
require 'webrick/httpdate'

module WEBrick
  class Cookie

    attr_reader :name
    attr_accessor :value, :version
    attr_accessor :domain, :path, :secure
    attr_accessor :comment, :max_age
    #attr_accessor :comment_url, :discard, :port

    def initialize(name, value)
      @name = name
      @value = value
      @version = 0     # Netscape Cookie

      @domain = @path = @secure = @comment = @max_age =
      @expires = @comment_url = @discard = @port = nil
    end

    def expires=(t)
      @expires = t.is_a?(Time) ? HTTPDate::time2s(t) : t.to_s
    end

    def expires
      @expires && HTTPDate::s2time(@expires)
    end

    def to_s
      ret = ""
      ret << @name << "=" << @value
      ret << "; " << "Version=" << @version.to_s if @version > 0
      ret << "; " << "Domain="  << @domain  if @domain
      ret << "; " << "Expires=" << @expires if @expires
      ret << "; " << "Max-Age=" << @max_age.to_s if @max_age
      ret << "; " << "Comment=" << @comment if @comment
      ret << "; " << "Path="    << @path if @path
      ret << "; " << "Secure"   if @secure
      ret
    end

    # Cookie::parse()
    #   It parses Cookie field sent from the user agent.
    def self.parse(str)
      if str
        ret = []
        cookie = nil
        ver = 0
        str.split(/[;,]\s*/).each{|x|
          key, val = x.split(/=/,2)
          val = HTTPUtils::dequote(val)
          case key
          when "$Version"; ver = val.to_i
          when "$Path";    cookie.path = val
          when "$Domain";  cookie.domain = val
          when "$Port";    cookie.port = val
          else
            ret << cookie if cookie
            cookie = self.new(key, val)
            cookie.version = ver
          end
        }
        ret << cookie if cookie
        ret
      end
    end

  end
end
