#
# date.rb -- HTTPDate Module
#
# Author: IPR -- Internet Programming with Ruby -- writers
# Copyright (C) 2000, 2001 TAKAHASHI Masayoshi, GOTOU Yuuzou
#
# $IPR: httpdate.rb,v 1.4 2002/02/05 20:20:31 gotoyuzo Exp $

# Date.rb   utitlity for HTTP/1.1(RFC1123) date format.
#
#  sample of RFC1123 format : "Thu, 03 Feb 1994 17:09:00 GMT"
#
#  cf. timezone (RFC 822   5.1. SYNTAX)
#
#   zone  =  "UT"  / "GMT"         ; Universal Time
#                                  ; North American : UT
#         /  "EST" / "EDT"         ;  Eastern:  - 5/ - 4
#         /  "CST" / "CDT"         ;  Central:  - 6/ - 5
#         /  "MST" / "MDT"         ;  Mountain: - 7/ - 6
#         /  "PST" / "PDT"         ;  Pacific:  - 8/ - 7
#         /  1ALPHA                ; Military: Z = UT;
#                                  ;  A:-1; (J not used)
#                                  ;  M:-12; N:+1; Y:+12
#         / ( ("+" / "-") 4DIGIT ) ; Local differential
#                                  ;  hours+min. (HHMM)

require 'parsedate'

module WEBrick
  module HTTPDate

    Timezone = {
      "UT", "+0000",      "GMT","+0000",
      "EST","-0500",      "EDT","-0400",
      "CST","-0600",      "CDT","-0500",
      "MST","-0700",      "MDT","-0600",
      "PST","-0800",      "PDT","-0700",
      "A",  "-0100",      "M",  "-1200",
      "N",  "+0100",      "Y",  "+1200",
      "JST","+0900",
    }
  
    def format(t)
      if t.is_a(Time)
        time2s(t)
      else
        time2s(s2time(t))
      end
    end

    def time2s(d)
      d.gmtime.strftime("%a, %d %b %Y %X GMT")
    end
    module_function :time2s

    def s2time(str)
      yy, mm, dd, hh, m2, ss, zone = ParseDate::parsedate(str)
     
      if zone
	if Timezone[zone]
	  zone = Timezone[zone]
	end

	if zone =~ /([+-])(\d\d)(\d\d)/
	  hh += ($1+$2).to_i
	  m2 += ($1+$3).to_i
	end
      end
	
      return Time.gm(yy,mm,dd,hh,m2,ss)
    end
    module_function :s2time

  end
end
