/* -*-mode:java; c-basic-offset:2; -*- */
/* WeirdX - Guess.
 *
 * Copyright (C) 2000-2004 JCraft, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package com.jcraft.weirdx;


class Font_CharSet_FONTSPECIFIC implements Font_CharSet{

  private static char[] map={
    0x0000,0x0001,0x0002,0x0003,0x0004,0x0005,0x0006,0x0007,
    0x0008,0x0009,0x000a,0x000b,0x000c,0x000d,0x000e,0x000f,
    0x0010,0x0011,0x0012,0x0013,0x0014,0x0015,0x0016,0x0017,
    0x0018,0x0019,0x001a,0x001b,0x001c,0x001d,0x001e,0x001f,
    0x0020,0x0021,0x2200,0x0023,0x2203,0x0025,0x0026,0x220d,
    0x0028,0x0029,0x002a,0x002b,0x002c,0x002d,0x002e,0x002f,
    0x0030,0x0031,0x0032,0x0033,0x0034,0x0035,0x0036,0x0037,
    0x0038,0x0039,0x003a,0x003b,0x003c,0x003d,0x003e,0x003f,
    0x2245,0x0391,0x0392,0x03a7,0x0394,0x0395,0x03a6,0x0393,
    0x0397,0x0399,0x03d1,0x039a,0x039b,0x039c,0x039d,0x039f,
    0x03a0,0x0398,0x03a1,0x03a3,0x03a4,0x03a5,0x03c2,0x03a9,
    0x039e,0x03a8,0x0396,0x005b,0x2234,0x005d,0x22a5,0x005f,
    0x0020,0x03b1,0x03b2,0x03c7,0x03b4,0x03b5,0x03d5,0x03b3,
    0x03b7,0x03b9,0x03c6,0x03ba,0x03bb,0x03bc,0x03bd,0x03bf,
    0x03c0,0x03b8,0x03c1,0x03c3,0x03c4,0x03c5,0x03d6,0x03c9,
    0x03be,0x03c8,0x03b6,0x007b,0x007c,0x007d,0x007e,0x007f,

    0x0080,0x0081,0x0082,0x0083,0x0084,0x0085,0x0086,0x0087,
    0x0088,0x0089,0x008a,0x008b,0x008c,0x008d,0x008e,0x008f,
    0x0090,0x0091,0x0092,0x0093,0x0094,0x0095,0x0096,0x0097,
    0x0098,0x0099,0x009a,0x009b,0x009c,0x009d,0x009e,0x009f,
    0x00a0,0x03d2,0x0374,0x2264,0x2215,0x221e,0x2231,0x2663,
    0x2666,0x2665,0x2660,0x2194,0x2190,0x2191,0x2192,0x2193,
    0x2218,0x00b1,0x0022,0x2265,0x00d7,0x221d,0x2202,0x2219,
    0x00f7,0x2260,0x2261,0x2248,0x22ef,0x2223,0x2212,0x21b2,
    0x2135,0x2111,0x211c,0x2118,0x2297,0x2295,0x2205,0x22c2,
    0x22c3,0xcc83,0x2287,0x2284,0x2282,0x2286,0x2208,0x2209,
    0x2220,0x22bd,0x00ae,0x00a9,0x2122,0x220f,0x221a,0x22c5,
    0x00ac,0x2227,0x2228,0x21d4,0x21d0,0x21d1,0x21d2,0x21d3,
    0x226c,0x2329,0x00ae,0x00a9,0x2122,0x2211,0x0020,0x0020, // ??
    0x0020,0x0020,0x0020,0x230a,0x0020,0x0020,0x0020,0x0020, // ??
    0x0020,0x2328,0x222b,0x2308,0x0020,0x0020,0x0020,0x0020, // ??
    0x0020,0x0020,0x0020,0x230b,0x0020,0x0020,0x0020,0x0020  // ??
  };

  static int min_byte1=0;
  static int max_byte1=0;
  static int min_char_or_byte2=0x20;
  static int max_char_or_byte2=0xff;
  static int default_char=0x20;
  static String encoding="unknown";
  static String charset="fontspecific";

  public int getMinByte1(){return min_byte1;}
  public int getMaxByte1(){return max_byte1;}
  public int getMinCharOrByte2(){return min_char_or_byte2;}
  public int getMaxCharOrByte2(){return max_char_or_byte2;}
  public int getDefaultChar(){return default_char;}
  public String getEncoding(){return encoding;}
  public String getCharset(){return charset;}

  private static String[] _flist={
    "-misc-nil-medium-r-normal--2-20-75-75-c-10-misc-fontspecific"
  };

  private static String[] _flist_scalable={
    "-misc-nil-medium-r-normal--0-0-75-75-c-0-misc-fontspecific"
  };

  private static String[] _flist_scalable_proportional={
    "-adobe-symbol-medium-r-normal--0-0-0-0-p-0-adobe-fontspecific"
  };

  private static String[] _aliases={
  };

  public void init(){
    if(_flist==null)return;
    Font.addFont(_flist);
    _flist=null;
    Font.addFont(_flist_scalable);
    _flist_scalable=null;
    Font.addFont(_flist_scalable_proportional);
    _flist_scalable_proportional=null;
    Font.addAlias(_aliases);
  }

  public int encode(byte[] bbuffer, int start, int len, char[] cbuffer){
    //System.out.println("encode: start="+start+","+len);
    //for(int ii=start; ii<start+len; ii++){
    //  System.out.println(" "+Integer.toHexString(bbuffer[ii]&0xff));
    //}
    int i=0;
    int j=0;
    while(i<len){
      if(bbuffer[start+i]==0) i++; 
      cbuffer[j]=(char)(bbuffer[start+i]&0xff);
      i++; j++;
    }
    len=j;
    for(i=0; i<len; i++){
      cbuffer[i]=map[(cbuffer[i])&0xffff];
    }
    return len;
  }
}
